/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.factory;

import de.slashbinbash.hexen.action.ActionFactory;
import de.slashbinbash.hexen.check.CheckFactory;
import de.slashbinbash.hexen.factory.Factory;
import de.slashbinbash.hexen.factory.ModifierFactory;
import de.slashbinbash.hexen.model.Item;
import de.slashbinbash.hexen.model.ItemData;
import de.slashbinbash.hexen.model.ItemType;
import de.slashbinbash.hexen.struct.CacheMap;
import de.slashbinbash.util.StaticXML;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ItemFactory {
    private static CacheMap<ItemData> cache = new CacheMap();

    public static void clear() {
        cache.clear();
    }

    public static Item createItem(String string) {
        return new Item(ItemFactory.createItemDesc(string));
    }

    public static Item createItem(Element element) {
        return new Item(ItemFactory.createItemDesc(element));
    }

    public static ItemData createItemDesc(String string) {
        if (cache.has(string)) {
            return cache.get(string);
        }
        File file = new File(Factory.ITEM_PATH + string + ".xml");
        try {
            Document document = StaticXML.loadXML(file);
            ItemData itemData = ItemFactory.createItemDesc(document.getDocumentElement());
            itemData.__id__ = string;
            cache.put(string, itemData);
            return itemData;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    public static ItemData createItemDesc(Element element) {
        if (StaticXML.hasAttribute(element, "ref")) {
            return ItemFactory.createItemDesc(StaticXML.getAttribute(element, "ref"));
        }
        ItemData itemData = new ItemData();
        String string = StaticXML.getAttribute(element, "type");
        if (string == null) {
            string = "default";
        }
        switch (string) {
            case "document": {
                itemData.type = ItemType.Document;
                itemData.dropable = true;
                itemData.equipable = false;
                itemData.sellable = true;
                itemData.stackable = false;
                itemData.unequipable = false;
                itemData.useable = false;
                break;
            }
            case "equip": 
            case "equipable": {
                itemData.type = ItemType.Equip;
                itemData.dropable = true;
                itemData.equipable = true;
                itemData.sellable = true;
                itemData.stackable = false;
                itemData.unequipable = false;
                itemData.useable = false;
                break;
            }
            case "consume": 
            case "consumable": {
                itemData.type = ItemType.Consume;
                itemData.dropable = true;
                itemData.equipable = false;
                itemData.sellable = true;
                itemData.stackable = true;
                itemData.unequipable = false;
                itemData.useable = true;
                itemData.stackSize = 999;
                break;
            }
            case "trade": {
                itemData.type = ItemType.Trade;
                itemData.dropable = true;
                itemData.equipable = false;
                itemData.sellable = true;
                itemData.stackable = true;
                itemData.unequipable = false;
                itemData.useable = false;
                itemData.stackSize = 999;
                break;
            }
            case "quest": {
                itemData.type = ItemType.Quest;
                itemData.dropable = false;
                itemData.equipable = false;
                itemData.sellable = false;
                itemData.stackable = false;
                itemData.unequipable = false;
                itemData.useable = false;
                break;
            }
            case "unidentified": {
                itemData.type = ItemType.Unidentified;
                itemData.dropable = true;
                itemData.equipable = false;
                itemData.sellable = true;
                itemData.stackable = false;
                itemData.unequipable = false;
                itemData.useable = false;
                break;
            }
            default: {
                StaticXML.errInvalidAttributeValue(element, "type", string);
            }
        }
        block44: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "name": {
                    itemData.name = StaticXML.getText(element2);
                    continue block44;
                }
                case "description": {
                    itemData.description = StaticXML.hasText(element2) ? Factory.unformatMD(StaticXML.getText(element2)) : "";
                    continue block44;
                }
                case "value": {
                    itemData.value = Integer.valueOf(StaticXML.getText(element2));
                    continue block44;
                }
                case "stackSize": {
                    itemData.stackSize = Integer.valueOf(StaticXML.getText(element2));
                    continue block44;
                }
                case "sellable": {
                    itemData.sellable = Boolean.valueOf(StaticXML.getText(element2));
                    continue block44;
                }
                case "unequipable": {
                    itemData.unequipable = Boolean.valueOf(StaticXML.getText(element2));
                    continue block44;
                }
                case "actions": {
                    itemData.actions = ActionFactory.createActions(element2);
                    continue block44;
                }
                case "modifiers": {
                    itemData.modifiers = ModifierFactory.createModifiers(element2);
                    continue block44;
                }
                case "requirements": {
                    itemData.requirements = CheckFactory.createChecks(element2);
                    continue block44;
                }
                case "text": {
                    itemData.text = Factory.unformatMD(StaticXML.getText(element2));
                    continue block44;
                }
                case "craft": {
                    itemData.craftable = true;
                    continue block44;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return itemData;
    }

    public static List<Item> createItems(Element element) {
        ArrayList<Item> arrayList = new ArrayList<Item>();
        block6: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "item": {
                    arrayList.add(ItemFactory.createItem(element2));
                    continue block6;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        arrayList.trimToSize();
        return arrayList;
    }
}

