/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.factory;

import de.slashbinbash.hexen.factory.Factory;
import de.slashbinbash.hexen.model.ItemDrop;
import de.slashbinbash.hexen.model.ItemDrops;
import de.slashbinbash.util.StaticXML;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ItemDropsFactory {
    private static ItemDrop.Entry createItemDropEntry(Element element) {
        String string = StaticXML.getAttribute(element, "ref");
        int n = StaticXML.getInt(element, "min", 1);
        int n2 = StaticXML.getInt(element, "max", 1);
        return new ItemDrop.Entry(string, n, n2);
    }

    private static List<ItemDrop.Entry> createItemDropEntries(Element element) {
        ArrayList<ItemDrop.Entry> arrayList = new ArrayList<ItemDrop.Entry>();
        for (Element element2 : StaticXML.getChildElements(element)) {
            arrayList.add(ItemDropsFactory.createItemDropEntry(element2));
        }
        return arrayList;
    }

    public static ItemDrops createItemDrops(String string) {
        try {
            Document document = StaticXML.loadXML(new File(Factory.CREATURE_PATH + string + ".xml"));
            Element element = document.getDocumentElement();
            Element element2 = StaticXML.getElement(element, "itemDrops");
            if (element2 == null) {
                return null;
            }
            ItemDrops itemDrops = new ItemDrops();
            for (Element element3 : StaticXML.getChildElements(element2)) {
                switch (element3.getTagName()) {
                    case "item": {
                        if (itemDrops.list == null) {
                            itemDrops.list = new ArrayList();
                        }
                        String string2 = StaticXML.getAttribute(element3, "ref");
                        int n = StaticXML.getInt(element3, "min", 1);
                        int n2 = StaticXML.getInt(element3, "max", 1);
                        itemDrops.list.add(new ItemDrop.Entry(string2, n, n2));
                        break;
                    }
                    case "oneOf": {
                        itemDrops.oneOf = ItemDropsFactory.createItemDropEntries(element3);
                    }
                }
            }
            return itemDrops;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

