/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.factory;

import de.slashbinbash.hexen.PAKValidator;
import de.slashbinbash.hexen.Util;
import de.slashbinbash.hexen.combat.Summon;
import de.slashbinbash.hexen.enums.Component;
import de.slashbinbash.hexen.enums.DamageType;
import de.slashbinbash.hexen.factory.AbilityFactory;
import de.slashbinbash.hexen.factory.AttributeFactory;
import de.slashbinbash.hexen.factory.CombatActionFactory;
import de.slashbinbash.hexen.factory.ConditionFactory;
import de.slashbinbash.hexen.factory.DamageTypeFactory;
import de.slashbinbash.hexen.factory.ItemFactory;
import de.slashbinbash.hexen.factory.TraitFactory;
import de.slashbinbash.hexen.model.ConditionImmunities;
import de.slashbinbash.hexen.model.ConditionImmunity;
import de.slashbinbash.hexen.model.Damage;
import de.slashbinbash.hexen.model.DamageFloat;
import de.slashbinbash.hexen.model.DamageInteger;
import de.slashbinbash.hexen.model.DamageRange;
import de.slashbinbash.hexen.model.DamageRanges;
import de.slashbinbash.hexen.model.DamageReductions;
import de.slashbinbash.hexen.model.DamageResistances;
import de.slashbinbash.hexen.model.ItemData;
import de.slashbinbash.hexen.model.ItemGroup;
import de.slashbinbash.hexen.model.ItemStack;
import de.slashbinbash.hexen.model.Path;
import de.slashbinbash.hexen.model.RestoreRange;
import de.slashbinbash.util.StaticXML;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Element;

public class Factory {
    private static String PAK = "pak";
    public static String PAK_PATH = "data/" + PAK;
    public static String PAK_DB = PAK_PATH + "/db";
    public static String PAK_ASSETS = PAK_PATH + "/assets";
    public static String ABILITY_PATH = PAK_DB + "/ability/";
    public static String ATTRIBUTE_PATH = PAK_DB + "/attribute/";
    public static String COMBAT_ACTION_PATH = PAK_DB + "/combat_action/";
    public static String CONDITION_PATH = PAK_DB + "/condition/";
    public static String CREATURE_PATH = PAK_DB + "/creature/";
    public static String DAMAGE_TYPE_PATH = PAK_DB + "/damage_type/";
    public static String EVENT_PATH = PAK_DB + "/event/";
    public static String GUILD_PATH = PAK_DB + "/guild/";
    public static String INN_PATH = PAK_DB + "/inn/";
    public static String ITEM_PATH = PAK_DB + "/item/";
    public static String MAP_PATH = PAK_DB + "/map/";
    public static String MODDER_PATH = PAK_DB + "/modder/";
    public static String MOD_PATH = PAK_DB + "/mod/";
    public static String QUEST_PATH = PAK_DB + "/quest/";
    public static String SCENE_PATH = PAK_DB + "/scene/";
    public static String SHOP_PATH = PAK_DB + "/shop/";
    public static String TEMPLE_PATH = PAK_DB + "/temple/";
    public static String TRAIT_PATH = PAK_DB + "/trait/";
    public static String TRAVEL_PATH = PAK_DB + "/travel/";
    public static String WORKBENCH_PATH = PAK_DB + "/workbench/";
    public static String PORTRAIT_PATH = PAK_ASSETS + "/img/portrait/";
    public static String AVATAR_PATH = PAK_ASSETS + "/img/portrait/cc/";
    public static String BACKGROUND_PATH = PAK_ASSETS + "/img/background/";
    public static String MAPIMG_PATH = PAK_ASSETS + "/img/map/";
    public static String WAV_PATH = PAK_ASSETS + "/wav/";
    public static String SAVES_PATH = "saves/";

    public static void clearAllCaches() {
        AbilityFactory.clear();
        AttributeFactory.clear();
        CombatActionFactory.clear();
        ConditionFactory.clear();
        DamageTypeFactory.clear();
        ItemFactory.clear();
        TraitFactory.clear();
    }

    public static void loadAllCaches() {
        AbilityFactory.load();
        AttributeFactory.load();
        DamageTypeFactory.load();
        TraitFactory.load();
    }

    public static DamageRange createDamageRange(Element element) {
        Component component = Component.valueOf(StaticXML.getAttribute(element, "component"));
        DamageType damageType = DamageType.valueOf(StaticXML.getAttribute(element, "type"));
        int n = StaticXML.getInt(element, "min");
        int n2 = StaticXML.getInt(element, "max");
        return new DamageRange(new Damage(component, damageType), n, n2);
    }

    public static DamageRanges createDamageRanges(Element element) {
        DamageRanges damageRanges = new DamageRanges();
        block6: for (Element element2 : StaticXML.getChildElements(element)) {
            String string;
            switch (string = element2.getTagName()) {
                case "damageRange": {
                    damageRanges.set(Factory.createDamageRange(element2));
                    continue block6;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        assert (!damageRanges.isEmpty());
        return damageRanges;
    }

    public static long parseDuration(Element element) {
        long l = 0L;
        l += (long)(StaticXML.getInt(element, "years", 0) * 31536000);
        l += (long)(StaticXML.getInt(element, "days", 0) * 86400);
        l += (long)(StaticXML.getInt(element, "hours", 0) * 3600);
        l += (long)(StaticXML.getInt(element, "minutes", 0) * 60);
        return l += (long)StaticXML.getInt(element, "seconds", 0);
    }

    public static int parseTime(String string) {
        int n = 0;
        String[] stringArray = string.split(":");
        n += Integer.valueOf(stringArray[0]) * 60 * 60;
        n += Integer.valueOf(stringArray[1]) * 60;
        if (stringArray.length == 3) {
            n += Integer.valueOf(stringArray[2]).intValue();
        }
        return n;
    }

    public static DamageFloat createDamageRatio(Element element) {
        Component component = Component.valueOf(StaticXML.getAttribute(element, "component"));
        DamageType damageType = DamageType.valueOf(StaticXML.getAttribute(element, "type"));
        float f = StaticXML.getFloat(element, "value");
        return new DamageFloat(new Damage(component, damageType), f);
    }

    public static DamageReductions createDamageReductions(Element element) {
        DamageReductions damageReductions = new DamageReductions();
        block6: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "damageValue": {
                    DamageInteger damageInteger = Factory.createDamageValue(element2);
                    damageReductions.put(damageInteger.damage, damageInteger.value);
                    continue block6;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return damageReductions;
    }

    public static DamageResistances createDamageResistances(Element element) {
        DamageResistances damageResistances = new DamageResistances();
        block6: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "damageRatio": {
                    DamageFloat damageFloat = Factory.createDamageRatio(element2);
                    damageResistances.put(damageFloat.damage, Float.valueOf(damageFloat.value));
                    continue block6;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return damageResistances;
    }

    public static DamageInteger createDamageValue(Element element) {
        Component component = Component.valueOf(StaticXML.getAttribute(element, "component"));
        DamageType damageType = DamageType.valueOf(StaticXML.getAttribute(element, "type"));
        int n = Integer.parseInt(StaticXML.getAttribute(element, "value"));
        return new DamageInteger(new Damage(component, damageType), n);
    }

    public static ConditionImmunities createConditionImmunities(Element element) {
        ConditionImmunities conditionImmunities = new ConditionImmunities();
        block7: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "condition": 
                case "immunity": {
                    String string = element2.getAttribute("ref");
                    conditionImmunities.add(Factory.createConditionImmunity(string));
                    continue block7;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return conditionImmunities;
    }

    public static ConditionImmunity createConditionImmunity(String string) {
        assert (string != null);
        ConditionImmunity conditionImmunity = new ConditionImmunity();
        conditionImmunity.conditionId = string;
        return conditionImmunity;
    }

    public static ConditionImmunity createImmunity(Element element) {
        return Factory.createConditionImmunity(StaticXML.getAttribute(element, "ref"));
    }

    public static List<ItemStack> createItemStack(String string, int n) {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        while (n > 0) {
            ItemData itemData = ItemFactory.createItem((String)string)._data;
            int n2 = Math.min(itemData.stackSize, n);
            n -= n2;
            arrayList.add(new ItemStack(itemData, n2));
        }
        return arrayList;
    }

    public static ItemGroup createItemGroup(Element element) {
        assert (StaticXML.hasAttribute(element, "ref"));
        String string = StaticXML.getAttribute(element, "ref");
        int n = StaticXML.getInt(element, "amount", 1);
        return new ItemGroup(string, n);
    }

    public static List<ItemGroup> createItemGroups(Element element) {
        ArrayList<ItemGroup> arrayList = new ArrayList<ItemGroup>();
        block6: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "item": {
                    arrayList.add(Factory.createItemGroup(element2));
                    continue block6;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return arrayList;
    }

    public static List<ItemStack> createItemStack(Element element) {
        assert (StaticXML.hasAttribute(element, "ref"));
        String string = StaticXML.getAttribute(element, "ref");
        int n = 1;
        if (StaticXML.hasAttribute(element, "amount")) {
            n = StaticXML.getInt(element, "amount");
        }
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        while (n > 0) {
            ItemData itemData = ItemFactory.createItem((String)string)._data;
            int n2 = Math.min(itemData.stackSize, n);
            n -= n2;
            arrayList.add(new ItemStack(itemData, n2));
        }
        return arrayList;
    }

    public static List<ItemStack> createItemStacks(Element element) {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        block6: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "item": {
                    arrayList.addAll(Factory.createItemStack(element2));
                    continue block6;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return arrayList;
    }

    public static Path createPath(Element element) {
        Path path = new Path();
        path.mapId = StaticXML.getAttribute(element, "map");
        path.level = StaticXML.getInt(element, "level");
        path.x = StaticXML.getInt(element, "x");
        path.y = StaticXML.getInt(element, "y");
        return path;
    }

    public static RestoreRange createRestoreRange(Element element) {
        Component component = Component.valueOf(StaticXML.getAttribute(element, "component"));
        int n = Integer.parseInt(StaticXML.getAttribute(element, "min"));
        int n2 = Integer.parseInt(StaticXML.getAttribute(element, "max"));
        return new RestoreRange(component, n, n2);
    }

    public static HashMap<String, Float> createStats(Element element) {
        HashMap<String, Float> hashMap = new HashMap<String, Float>();
        for (Element element2 : StaticXML.getChildElements(element)) {
            String string = StaticXML.getAttribute(element2, "name");
            float f = StaticXML.getFloat(element2, "value");
            hashMap.put(string, Float.valueOf(f));
        }
        return hashMap;
    }

    public static Summon.SummonDescription createSummonDescription(Element element) {
        Summon.SummonDescription summonDescription = new Summon.SummonDescription();
        if (StaticXML.hasAttribute(element, "type")) {
            summonDescription.type = Summon.Type.valueOf(StaticXML.getAttribute(element, "type"));
        }
        summonDescription.creature = StaticXML.getAttribute(element, "ref");
        summonDescription.playable = StaticXML.getBool(element, "playable", false);
        return summonDescription;
    }

    public static String getElementUID(Element element) {
        if (!StaticXML.hasAttribute(element, "id")) {
            throw new RuntimeException(element.getOwnerDocument().getDocumentURI() + ": element requires attribute 'id'");
        }
        Object object = null;
        File file = new File(element.getOwnerDocument().getDocumentURI());
        String string = file.getName();
        assert (string.endsWith(".xml"));
        object = string.substring(0, string.length() - 4);
        object = (String)object + "." + StaticXML.getAttribute(element, "id");
        return object;
    }

    public static String hashMD5(String string) {
        return string;
    }

    public static void setPAK(String string, String string2) {
        PAK = string2;
        PAK_PATH = string.equals(".") ? "data/" + PAK : string + "/data/" + PAK;
        PAK_DB = PAK_PATH + "/db";
        PAK_ASSETS = PAK_PATH + "/assets";
        ABILITY_PATH = PAK_DB + "/ability/";
        ATTRIBUTE_PATH = PAK_DB + "/attribute/";
        COMBAT_ACTION_PATH = PAK_DB + "/combat_action/";
        CONDITION_PATH = PAK_DB + "/condition/";
        CREATURE_PATH = PAK_DB + "/creature/";
        DAMAGE_TYPE_PATH = PAK_DB + "/damage_type/";
        EVENT_PATH = PAK_DB + "/event/";
        TRAIT_PATH = PAK_DB + "/trait/";
        GUILD_PATH = PAK_DB + "/guild/";
        INN_PATH = PAK_DB + "/inn/";
        ITEM_PATH = PAK_DB + "/item/";
        MAP_PATH = PAK_DB + "/map/";
        MODDER_PATH = PAK_DB + "/modder/";
        MOD_PATH = PAK_DB + "/mod/";
        QUEST_PATH = PAK_DB + "/quest/";
        SCENE_PATH = PAK_DB + "/scene/";
        SHOP_PATH = PAK_DB + "/shop/";
        TEMPLE_PATH = PAK_DB + "/temple/";
        TRAVEL_PATH = PAK_DB + "/travel/";
        WORKBENCH_PATH = PAK_DB + "/workbench/";
        PORTRAIT_PATH = PAK_ASSETS + "/img/portrait/";
        AVATAR_PATH = PAK_ASSETS + "/img/portrait/cc/";
        BACKGROUND_PATH = PAK_ASSETS + "/img/background/";
        MAPIMG_PATH = PAK_ASSETS + "/img/map/";
        WAV_PATH = PAK_ASSETS + "/wav/";
    }

    public static String unformatMD(String string) {
        return Util.unformatMD(string);
    }

    public static boolean validatePak() {
        return PAKValidator.validatePak(PAK_PATH);
    }
}

