/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.factory;

import de.slashbinbash.hexen.enums.Attribute;
import de.slashbinbash.hexen.factory.Factory;
import de.slashbinbash.hexen.model.Attributes;
import de.slashbinbash.hexen.struct.CacheMap;
import de.slashbinbash.util.StaticXML;
import java.io.File;
import java.util.Collection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AttributeFactory {
    private static CacheMap<Attribute> cache = new CacheMap();

    public static void clear() {
        cache.clear();
    }

    public static void load() {
        assert (cache.isEmpty());
        File file = new File(Factory.ATTRIBUTE_PATH);
        for (File file2 : file.listFiles()) {
            if (!file2.isFile()) continue;
            String string = file2.getName();
            String string2 = string.substring(0, string.indexOf(".xml"));
            Attribute attribute = new Attribute();
            attribute.id = string2;
            try {
                Document document = StaticXML.loadXML(file2);
                AttributeFactory.initAttribute(document.getDocumentElement(), attribute);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                attribute.name = "<ERR:" + string2 + ">";
                attribute.description = "Failed to read " + file2.getAbsolutePath();
            }
            cache.put(string2, attribute);
        }
    }

    public static Attributes createAttributes(Element element) {
        Attributes attributes = new Attributes();
        block6: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "attribute": {
                    String string = StaticXML.getAttribute(element2, "name");
                    int n = Integer.parseInt(StaticXML.getAttribute(element2, "value"));
                    string = string.toLowerCase();
                    Attribute attribute = AttributeFactory.getAttribute(string);
                    assert (attribute != null) : "Attribute does not exist: " + string;
                    assert (!attributes.containsKey(attribute));
                    attributes.put(attribute, n);
                    continue block6;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return attributes;
    }

    public static Attribute getAttribute(String string) {
        if (cache.containsKey(string)) {
            return cache.get(string);
        }
        throw new RuntimeException("Unknown attribute: " + string);
    }

    private static Attribute initAttribute(Element element, Attribute attribute) {
        block8: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "name": {
                    attribute.name = StaticXML.getText(element2);
                    continue block8;
                }
                case "description": {
                    attribute.description = StaticXML.getText(element2);
                    continue block8;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return attribute;
    }

    public static Collection<Attribute> values() {
        return cache.values();
    }
}

