/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.factory;

import de.slashbinbash.hexen.enums.Ability;
import de.slashbinbash.hexen.factory.Factory;
import de.slashbinbash.hexen.model.Abilities;
import de.slashbinbash.hexen.struct.CacheMap;
import de.slashbinbash.util.StaticXML;
import java.io.File;
import java.util.Collection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AbilityFactory {
    private static CacheMap<Ability> cache = new CacheMap();

    public static void clear() {
        cache.clear();
    }

    public static void load() {
        assert (cache.isEmpty());
        File file = new File(Factory.ABILITY_PATH);
        for (File file2 : file.listFiles()) {
            if (!file2.isFile()) continue;
            String string = file2.getName();
            String string2 = string.substring(0, string.indexOf(".xml"));
            try {
                Document document = StaticXML.loadXML(file2);
                Ability ability = new Ability();
                ability.id = string2;
                AbilityFactory.initAbility(document.getDocumentElement(), ability);
                cache.put(string2, ability);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(-1);
            }
        }
    }

    public static Abilities createAbilities(Element element) {
        Abilities abilities = new Abilities();
        for (Element element2 : StaticXML.getElements(element, "ability")) {
            String string = StaticXML.getAttribute(element2, "name");
            int n = Integer.parseInt(StaticXML.getAttribute(element2, "value"));
            string = string.toLowerCase();
            Ability ability = AbilityFactory.getAbility(string);
            assert (ability != null) : "Ability does not exist: " + string;
            assert (!abilities.containsKey(ability));
            abilities.put(ability, n);
        }
        return abilities;
    }

    public static Ability getAbility(String string) {
        if (cache.containsKey(string)) {
            return cache.get(string);
        }
        throw new RuntimeException("Unknown ability: " + string);
    }

    private static Ability initAbility(Element element, Ability ability) {
        block10: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "name": {
                    ability.name = StaticXML.getText(element2);
                    continue block10;
                }
                case "description": {
                    ability.description = StaticXML.getText(element2);
                    continue block10;
                }
                case "level": {
                    ability.skillLevel = StaticXML.getText(element2).toLowerCase();
                    continue block10;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return ability;
    }

    public static Collection<Ability> values() {
        return cache.values();
    }
}

