/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.event;

import de.slashbinbash.hexen.action.Action;
import de.slashbinbash.hexen.action.Actions;
import de.slashbinbash.hexen.event.Event;
import de.slashbinbash.hexen.event.EventData;
import de.slashbinbash.hexen.event.EventInput;
import de.slashbinbash.hexen.event.EventNode;
import de.slashbinbash.hexen.event.EventNodeSelector;
import de.slashbinbash.hexen.event.EventOption;
import de.slashbinbash.hexen.message.Message;
import de.slashbinbash.hexen.message.MessageBus;
import de.slashbinbash.hexen.model.Scene;
import de.slashbinbash.hexen.struct.Vars;
import java.util.ArrayList;

public class EventState {
    public static final int STATE_NONE = 0;
    public static final int STATE_ENTERED = 1;
    public static final int STATE_EXITED = 2;
    private EventData data = null;
    private Event.State state = null;
    private String saveId = "";
    public Vars vars = new Vars();
    public Scene scene = null;
    public String eventId = null;
    public String nodeId = null;
    public String optionId = null;
    public String text = null;
    public ArrayList<EventOption> options = new ArrayList(0);
    public Actions actions = null;
    public EventInput input = null;

    public EventState(EventData eventData, Event.State state) {
        this.data = eventData;
        this.state = state;
        this.eventId = eventData.id;
        this.nodeId = "0";
    }

    public void enterNode(String string) {
        MessageBus.push(Message.EVENT_ON_ENTER_NODE, this);
    }

    public EventOption getOption(int n) {
        return !this.options.isEmpty() ? this.options.get(n) : null;
    }

    public EventOption getOption(String string) {
        for (EventOption eventOption : this.options) {
            if (eventOption.id == null || !eventOption.id.equals(string)) continue;
            return eventOption;
        }
        return null;
    }

    public void handleEOF(EventOption eventOption) {
        MessageBus.push(Message.STATE_POP, this);
    }

    public boolean hasOptions() {
        return !this.options.isEmpty();
    }

    public void input(String string) {
        if (this.input == null) {
            return;
        }
        String string2 = null;
        for (EventInput.Test object : this.input.tests) {
            if (!object.test(string)) continue;
            string2 = object.next;
            break;
        }
        if (string2 != null) {
            this.loadEventNode(string2);
            if (this.actions != null) {
                for (Action action : this.actions) {
                    action.perform(this);
                }
            }
            this.enterNode(string2);
        }
    }

    public void pick(EventOption eventOption) {
        if (!eventOption.enabled) {
            return;
        }
        String string = this.nodeId;
        if (eventOption.actions != null) {
            for (Action action : eventOption.actions) {
                action.perform(this);
            }
        }
        if ((string = eventOption.next != null ? eventOption.next : (eventOption.nextChecks != null ? eventOption.nextChecks.check() : null)) != null) {
            this.loadEventNode(string);
            if (this.actions != null) {
                for (Action action : this.actions) {
                    action.perform(this);
                }
            }
            this.enterNode(string);
        } else {
            this.handleEOF(eventOption);
        }
    }

    private void loadEventNode(String string) {
        if (!this.data.nodes.containsKey(string)) {
            return;
        }
        EventNode eventNode = this.data.nodes.get(string);
        this.nodeId = eventNode.id;
        this.text = eventNode.text;
        this.options = eventNode.options;
        this.actions = eventNode.actions;
        this.input = eventNode.input;
        this.scene = eventNode.scene != null ? eventNode.scene : this.data.scene;
        for (EventOption eventOption : eventNode.options) {
            if (eventOption.visibleChecks == null) continue;
            eventOption.visible = eventOption.visibleChecks.checkAll(this);
        }
    }

    public void run() {
        if (this.data.selector != null) {
            for (EventNodeSelector.Entry entry : this.data.selector.list) {
                if (entry.checks.checkAll(this)) {
                    if (entry.successId == null) continue;
                    this.nodeId = entry.successId;
                    break;
                }
                if (entry.failureId == null) continue;
                this.nodeId = entry.failureId;
                break;
            }
        }
        this.loadEventNode(this.nodeId);
        this.enterNode(this.nodeId);
    }

    public void setNode(String string) {
        this.nodeId = string;
    }

    public Object getState(String string) {
        String string2 = this.data.id + "#" + this.saveId + "#" + string;
        return this.state.map.get(string2);
    }

    public void setState(String string, Object object) {
        String string2 = this.data.id + "#" + this.saveId + "#" + string;
        this.state.map.put(string2, object);
    }
}

