/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.encounter;

import de.slashbinbash.hexen.action.ActionFactory;
import de.slashbinbash.hexen.check.CheckFactory;
import de.slashbinbash.hexen.combat.CombatFactory;
import de.slashbinbash.hexen.encounter.Encounter;
import de.slashbinbash.hexen.event.EventFactory;
import de.slashbinbash.util.StaticXML;
import org.w3c.dom.Element;

public class EncounterFactory {
    public static Encounter.Entry createEncounterEntry(Element element) {
        Encounter.Entry entry = new Encounter.Entry();
        entry.chance = StaticXML.getFloat(element, "chance");
        block12: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "condition": {
                    entry.condition = CheckFactory.createChecks(element2);
                    continue block12;
                }
                case "actions": {
                    entry.actions = ActionFactory.createActions(element2);
                    continue block12;
                }
                case "combat": {
                    entry.combat = CombatFactory.createCombatDescriptor(element2);
                    continue block12;
                }
                case "event": {
                    entry.event = EventFactory.createEventDescriptor(element2);
                    continue block12;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return entry;
    }

    public static Encounter.Type createEncounterType(Element element, int n) {
        Encounter.Type type = new Encounter.Type(n);
        block12: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "entry": {
                    type.entries.add(EncounterFactory.createEncounterEntry(element2));
                    continue block12;
                }
                case "actions": {
                    Encounter.Entry entry = new Encounter.Entry();
                    entry.chance = StaticXML.getFloat(element2, "chance", 1.0f);
                    entry.actions = ActionFactory.createActions(element2);
                    type.entries.add(entry);
                    continue block12;
                }
                case "combat": {
                    Encounter.Entry entry = new Encounter.Entry();
                    entry.chance = StaticXML.getFloat(element2, "chance", 1.0f);
                    entry.combat = CombatFactory.createCombatDescriptor(element2);
                    type.entries.add(entry);
                    continue block12;
                }
                case "event": {
                    Encounter.Entry entry = new Encounter.Entry();
                    entry.chance = StaticXML.getFloat(element2, "chance", 1.0f);
                    entry.event = EventFactory.createEventDescriptor(element2);
                    type.entries.add(entry);
                    continue block12;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return type;
    }

    public static Encounter createEncounter(Element element) {
        Encounter encounter = new Encounter();
        block13: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "once": {
                    encounter.once = EncounterFactory.createEncounterType(element2, 2);
                    continue block13;
                }
                case "always": {
                    encounter.always = EncounterFactory.createEncounterType(element2, 1);
                    continue block13;
                }
                case "rest": 
                case "resting": {
                    encounter.resting = EncounterFactory.createEncounterType(element2, 3);
                    continue block13;
                }
                case "condition": {
                    encounter.condition = CheckFactory.createChecks(element2);
                    continue block13;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return encounter;
    }
}

