/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.deadpool;

import de.slashbinbash.hexen.model.ClassCreature;
import de.slashbinbash.hexen.model.Party;

public class DeadpoolSystem {
    public Entry entry = null;
    public int lostSouls = 0;

    public boolean contains(ClassCreature classCreature) {
        return this.entry != null && this.entry.party.containsMember(classCreature);
    }

    public boolean contains(de.slashbinbash.hexen.map.Location location) {
        return this.contains(location.mapId, location.level, location.x, location.y);
    }

    public boolean contains(String string, int n, int n2, int n3) {
        return this.entry != null ? this.entry.location.equals(string, n, n2, n3) : false;
    }

    public int count(de.slashbinbash.hexen.map.Location location) {
        return this.count(location.mapId, location.level, location.x, location.y);
    }

    public int count(String string, int n, int n2, int n3) {
        return this.entry != null && this.entry.location.equals(string, n, n2, n3) ? this.entry.party.getMembers().size() : 0;
    }

    public int countLostSouls() {
        return this.lostSouls;
    }

    public Entry get(de.slashbinbash.hexen.map.Location location) {
        return this.get(location.mapId, location.level, location.x, location.y);
    }

    public Entry get(String string, int n, int n2, int n3) {
        return this.entry != null && this.entry.location.equals(string, n, n2, n3) ? this.entry : null;
    }

    public boolean isEmpty() {
        return this.entry == null;
    }

    public void releaseSouls(int n) {
        this.lostSouls = Math.max(this.lostSouls - n, 0);
    }

    public Entry searchLevel(String string, int n) {
        return this.entry != null && this.entry.location.map.equals(string) && this.entry.location.level == n ? this.entry : null;
    }

    public Entry searchMap(String string) {
        return this.entry != null && this.entry.location.map.equals(string) ? this.entry : null;
    }

    public void set(Party party) {
        if (this.entry != null) {
            this.lostSouls += this.entry.party.getMembers().size();
            this.entry = null;
        }
        if (party != null) {
            this.entry = new Entry(party);
            this.entry.party.setLocation(null);
        }
    }

    public static class Entry {
        public Location location;
        public Party party;

        public Entry() {
        }

        public Entry(Party party) {
            de.slashbinbash.hexen.map.Location location = party.getLocation();
            this.location = new Location(location.mapId, location.level, location.x, location.y);
            this.party = party;
            this.party.getLocation().map = null;
        }
    }

    public static class Location {
        public String map;
        public int level;
        public int x;
        public int y;

        public Location(String string, int n, int n2, int n3) {
            this.map = string;
            this.level = n;
            this.x = n2;
            this.y = n3;
        }

        public boolean equals(Object object) {
            if (object instanceof Location) {
                Location location = (Location)object;
                return this.map.equals(location.map) && this.level == location.level && this.x == location.x && this.y == location.y;
            }
            return false;
        }

        public boolean equals(String string, int n, int n2, int n3) {
            return this.map.equals(string) && this.level == n && n2 == this.x && this.y == n3;
        }
    }
}

