/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.combat;

import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.StaticRPG;
import de.slashbinbash.hexen.Util;
import de.slashbinbash.hexen.action.Action;
import de.slashbinbash.hexen.action.Actions;
import de.slashbinbash.hexen.action.AddCondition;
import de.slashbinbash.hexen.action.DealDamage;
import de.slashbinbash.hexen.action.InstaKill;
import de.slashbinbash.hexen.action.RemoveCondition;
import de.slashbinbash.hexen.action.RestoreHP;
import de.slashbinbash.hexen.action.StealHP;
import de.slashbinbash.hexen.action.StealItem;
import de.slashbinbash.hexen.action.SummonCreature;
import de.slashbinbash.hexen.combat.CombatLog;
import de.slashbinbash.hexen.combat.CombatState;
import de.slashbinbash.hexen.combat.Combatant;
import de.slashbinbash.hexen.combat.CombatantGroup;
import de.slashbinbash.hexen.combat.Summon;
import de.slashbinbash.hexen.enums.Ability;
import de.slashbinbash.hexen.enums.Target;
import de.slashbinbash.hexen.factory.CombatLevelsFactory;
import de.slashbinbash.hexen.factory.CreatureFactory;
import de.slashbinbash.hexen.factory.ItemFactory;
import de.slashbinbash.hexen.model.ClassCreature;
import de.slashbinbash.hexen.model.CombatAction;
import de.slashbinbash.hexen.model.Condition;
import de.slashbinbash.hexen.model.DamageInteger;
import de.slashbinbash.hexen.model.DamageRange;
import de.slashbinbash.hexen.model.Item;
import de.slashbinbash.hexen.model.ItemDrops;
import de.slashbinbash.hexen.model.ItemLoot;
import de.slashbinbash.hexen.model.ItemStacks;
import de.slashbinbash.hexen.model.Party;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class StaticCombat {
    public static final float RUN_AWAY_CHANCE = 0.95f;
    public static final int SECONDS_PER_ROUND = 1;
    public static final int NUM_COMBAT_ACTIONS = 6;
    public static final float ENEMY_DAMAGE_MULTIPLIER = 1.0f;
    public static final CombatLevelsFactory.CombatLevels COMBAT_LEVELS = CombatLevelsFactory.createCombatLevels();

    private static void addCondition(Condition condition, Combatant combatant, CombatLog combatLog) {
        if (condition == null) {
            return;
        }
        if (combatant.isImmuneToCondition(condition)) {
            combatLog.IsImmuneTo(combatant, condition);
        } else {
            combatant.addCondition(condition);
            combatLog.AddCondition(combatant, condition);
        }
    }

    public static StaticRPG.Result doCombatAction(CombatAction combatAction, Combatant combatant3, CombatantGroup combatantGroup, CombatLog combatLog) {
        List<Condition> list;
        int n;
        assert (combatAction != null);
        assert (combatant3 != null);
        assert (combatantGroup != null && !combatantGroup.isEmpty());
        Target target = combatAction.getTarget();
        int n2 = combatAction.getActionPointCost();
        float f = combatAction.getHitChance();
        float f2 = combatAction.getCritChance();
        float f3 = combatAction.getCritMultiplier();
        Actions actions = combatAction.getActions();
        Actions actions2 = combatAction.getActionsOnCritHit();
        if (combatAction._data.base != null) {
            n = combatant3.creature.calcAbilityScore(Ability.valueOf(combatAction._data.base));
            if (n <= 0) {
                System.err.println("StaticCombat: Combat skill level 0: " + combatant3.getId() + ", " + combatAction._data.base);
            }
            list = COMBAT_LEVELS.get(combatAction._data.base, n);
            f += ((CombatLevelsFactory.CombatLevels.Entry)((Object)list)).hitChance;
            f2 += ((CombatLevelsFactory.CombatLevels.Entry)((Object)list)).critChance;
        }
        combatantGroup = new CombatantGroup(combatantGroup);
        combatantGroup.removeIf(combatant -> !combatant.isActive());
        if (target == Target.ENEMY_GROUP_ONE) {
            Combatant combatant4 = combatantGroup.pickRandom(RPG.rand);
            combatantGroup.removeIf(combatant2 -> combatant2 != combatant4);
        }
        if (combatant3.getActionPoints() < n2) {
            return StaticRPG.Result.NOT_ENOUGH_ACTION_POINTS;
        }
        combatLog.AttacksWith(combatant3, combatantGroup.list(), combatAction);
        combatant3.creature.actionPoints = Math.max(combatant3.getActionPoints() - n2, 0);
        n = 0;
        for (Combatant combatant5 : combatantGroup) {
            assert (!combatant5.runAway);
            if (target != Target.SELF && target != Target.PARTY_ONE && target != Target.PARTY_ALL) {
                float f4 = f;
                f4 += combatant3.getHitChanceAttacker();
                f4 += combatant5.getHitChanceDefender();
                f4 = Util.clamp(f4, 0.0f, 1.0f);
                if (RPG.rand.nextFloat() > f4) {
                    combatLog.Miss(combatant3, combatant5);
                    continue;
                }
            }
            boolean bl = false;
            if (!combatant5.isImmuneToCrits()) {
                float f5 = f2;
                f5 += combatant3.getCritChance();
                f5 = Util.clamp(f5, 0.0f, 1.0f);
                bl = RPG.rand.nextFloat() <= f5;
            }
            Actions actions3 = new Actions();
            actions3.addAll(actions);
            if (bl && actions2 != null) {
                actions3.addAll(actions2);
            }
            for (Action action : actions3) {
                Object object;
                if (action instanceof AddCondition) {
                    AddCondition addCondition = (AddCondition)action;
                    if (!(addCondition.chance >= 1.0f) && !(RPG.rand.nextFloat() <= addCondition.chance)) continue;
                    object = new Condition(addCondition.condition, addCondition.duration);
                    StaticCombat.addCondition((Condition)object, combatant5, combatLog);
                    continue;
                }
                if (action instanceof DealDamage) {
                    DealDamage dealDamage = (DealDamage)action;
                    StaticCombat.doDamage(dealDamage.damageRange, bl, f3, combatant3, combatant5, combatLog);
                    n = 1;
                    object = combatant5.removeConditionsIf(condition -> condition.removeOnDamage());
                    combatLog.RemovedConditions(combatant5, (List<Condition>)object);
                    continue;
                }
                if (action instanceof InstaKill) {
                    InstaKill instaKill = (InstaKill)action;
                    instaKill.perform(combatant5.creature);
                    continue;
                }
                if (action instanceof RemoveCondition) {
                    RemoveCondition removeCondition = (RemoveCondition)action;
                    StaticCombat.removeCondition(removeCondition.conditionId, combatant5, combatLog);
                    continue;
                }
                if (action instanceof RestoreHP) {
                    RestoreHP restoreHP = (RestoreHP)action;
                    StaticCombat.doRestoreHp(restoreHP, combatant5, combatLog);
                    continue;
                }
                if (action instanceof StealHP) {
                    StealHP stealHP = (StealHP)action;
                    object = StaticCombat.doDamage(stealHP.damageRange, bl, f3, combatant3, combatant5, combatLog);
                    n = 1;
                    List<Condition> list2 = combatant5.removeConditionsIf(condition -> condition.removeOnDamage());
                    combatLog.RemovedConditions(combatant5, list2);
                    StaticCombat.doRestoreHp(((DamageInteger)object).value, combatant3, combatLog);
                    continue;
                }
                if (action instanceof StealItem) {
                    StealItem stealItem = (StealItem)action;
                    if (combatant3.team != CombatState.Team.ENEMY || combatant5.team != CombatState.Team.ALLY) continue;
                    object = RPG.getInstance().party.inventory;
                    int n3 = RPG.rand.nextInt(stealItem.min, stealItem.max + 1);
                    int n4 = ((ItemStacks)object).remove(stealItem.itemID, n3);
                    Item item = ItemFactory.createItem(stealItem.itemID);
                    combatLog.StealItem(combatant3, item, n4);
                    continue;
                }
                assert (false);
            }
            if (!combatant5.isDead()) continue;
            combatLog.Defeated(combatant5);
        }
        if (n != 0) {
            list = combatant3.removeConditionsIf(condition -> condition.removeOnAttack());
            combatLog.RemovedConditions(combatant3, list);
        }
        return StaticRPG.Result.OK;
    }

    private static void doCondition(Combatant combatant, Condition condition, CombatLog combatLog) {
        if (condition.getActions() == null) {
            return;
        }
        ClassCreature classCreature = combatant.creature;
        for (Action action : condition.getActions()) {
            if (!(action instanceof DealDamage)) continue;
            DealDamage dealDamage = (DealDamage)action;
            DamageRange damageRange = dealDamage.damageRange;
            DamageInteger damageInteger = StaticRPG.roll(damageRange);
            int n = classCreature.calcDamageReduction(damageInteger.damage);
            damageInteger.value = Math.max(damageInteger.value - n, 0);
            classCreature.hitPoints = Math.max(classCreature.hitPoints - damageInteger.value, 0);
            if (combatLog == null) continue;
            combatLog.TookDamageFromCondition(combatant, damageInteger, condition);
        }
    }

    public static void doConditions(Combatant combatant, CombatLog combatLog) {
        List<Condition> list = combatant.removeConditionsIf(condition -> condition.timeLeftSeconds == 0L);
        for (Condition condition2 : list) {
            combatLog.RemoveCondition(combatant, condition2);
        }
        if (!combatant.hasConditions()) {
            return;
        }
        for (Condition condition2 : combatant.getConditions()) {
            StaticCombat.doCondition(combatant, condition2, combatLog);
        }
    }

    private static DamageInteger doDamage(DamageRange damageRange, boolean bl, float f, Combatant combatant, Combatant combatant2, CombatLog combatLog) {
        float f2;
        assert (damageRange != null);
        assert (f >= 0.0f);
        DamageInteger damageInteger = StaticRPG.roll(damageRange);
        float f3 = 1.0f;
        f3 += combatant.getDamageMultiplier(damageInteger.damage);
        f3 = Math.max(f3, 0.0f);
        if (combatant.team == CombatState.Team.ENEMY) {
            f3 *= 1.0f;
        }
        damageInteger.value = f3 < 1.0f ? Math.max(1, (int)((float)damageInteger.value * f3)) : (int)((float)damageInteger.value * f3);
        int n = combatant.getDamageAttack(damageInteger.damage);
        damageInteger.value = n < 0 ? Math.max(1, damageInteger.value + n) : (damageInteger.value += n);
        if (bl) {
            f2 = f;
            f2 += combatant.getCritMultiplier();
            f2 = Math.max(f2, 1.0f);
            damageInteger.value = (int)((float)damageInteger.value * f2);
        }
        f2 = 1.0f;
        f2 += combatant2.getDamageResistance(damageInteger.damage);
        f2 = Math.max(f2, 0.0f);
        damageInteger.value = (int)((float)damageInteger.value * f2);
        int n2 = 0;
        damageInteger.value = Math.max(damageInteger.value + (n2 += combatant2.getDamageReduction(damageInteger.damage)), 0);
        switch (damageInteger.getComponent()) {
            case HP: {
                combatant2.creature.hitPoints = Math.max(combatant2.getHitPoints() - damageInteger.value, 0);
                break;
            }
            case AP: {
                combatant2.creature.actionPoints = Math.max(combatant2.getActionPoints() - damageInteger.value, 0);
                break;
            }
            default: {
                assert (false) : "Unknown component";
                break;
            }
        }
        combatant2.recordDamage(combatant, damageInteger.value);
        combatLog.TookDamage(combatant2, damageInteger, bl);
        return damageInteger;
    }

    private static boolean doRestoreHp(int n, Combatant combatant, CombatLog combatLog) {
        assert (n > 0);
        if (!combatant.isActive()) {
            return false;
        }
        combatant.creature.hitPoints = Math.min(combatant.getHitPoints() + n, combatant.getMaxHitPoints());
        combatLog.RestoresHp(combatant, n);
        return true;
    }

    private static boolean doRestoreHp(RestoreHP restoreHP, Combatant combatant, CombatLog combatLog) {
        int n = StaticRPG.roll(restoreHP.min, restoreHP.max);
        return StaticCombat.doRestoreHp(n, combatant, combatLog);
    }

    private static boolean tryRunAwayMinChance(List<Combatant> list, float f) {
        float f2 = f;
        for (Combatant combatant : list) {
            if (!combatant.isAlive()) continue;
            if (!combatant.canRunAway()) {
                return false;
            }
            float f3 = Util.clamp(f + combatant.getRunAwayChance(), 0.0f, 1.0f);
            if (!(f3 < f2)) continue;
            f2 = f3;
        }
        return RPG.rand.nextFloat() < f2;
    }

    private static boolean tryRunAwayAllChance(List<Combatant> list, float f) {
        int n = 0;
        for (Combatant combatant : list) {
            if (!combatant.canRunAway()) break;
            float f2 = Util.clamp(f + combatant.getRunAwayChance(), 0.0f, 1.0f);
            if (!(RPG.rand.nextFloat() < f2)) continue;
            ++n;
        }
        return n == list.size();
    }

    public static boolean tryRunAway(List<Combatant> list, float f) {
        return StaticCombat.tryRunAwayMinChance(list, f);
    }

    public static void doRunAway(Combatant combatant, float f, CombatLog combatLog) {
        float f2 = Util.clamp(f + combatant.getRunAwayChance(), 0.0f, 1.0f);
        combatant.runAway = RPG.rand.nextFloat() < f2;
        combatLog.RunAway(combatant, combatant.runAway);
    }

    public static void doSummonAction(CombatAction combatAction, Combatant combatant, List<Combatant> list, CombatLog combatLog) {
        if (combatant.getActionPoints() < combatAction.getActionPointCost()) {
            return;
        }
        if (list.size() >= Party.MAX_SIZE + 1) {
            return;
        }
        combatant.creature.actionPoints -= combatAction.getActionPointCost();
        Summon.SummonDescription summonDescription = StaticCombat.getSummonAction((CombatAction)combatAction).desc;
        if (summonDescription.type == Summon.Type.AddCombatant) {
            ClassCreature classCreature = CreatureFactory.createCreature(summonDescription.creature);
            Combatant combatant2 = new Combatant(classCreature, combatant.team, summonDescription.playable);
            list.add(0, combatant2);
            combatLog.Summon(combatant, combatant2);
        } else if (summonDescription.type == Summon.Type.SwitchCombatant) {
            ClassCreature classCreature = CreatureFactory.createCreature(summonDescription.creature);
            Combatant combatant3 = new Combatant(classCreature, combatant.team, summonDescription.playable);
            int n = list.indexOf(combatant);
            list.set(n, combatant3);
            combatLog.Summon(combatant, combatant3);
        }
    }

    public static List<Combatant> filterRangeCombatants(CombatAction combatAction, Combatant combatant, List<Combatant> list) {
        ArrayList<Combatant> arrayList = new ArrayList<Combatant>();
        for (Combatant combatant2 : list) {
            if (!combatant2.isActive()) continue;
            int n = combatant2.range + combatant.range + 1;
            int n2 = combatAction.getRangeFrom().ordinal();
            int n3 = combatAction.getRangeTo().ordinal();
            if (n2 > n || n > n3) continue;
            arrayList.add(combatant2);
        }
        return arrayList;
    }

    public static List<CombatantGroup> filterRangeGroups(CombatAction combatAction, Combatant combatant, List<CombatantGroup> list) {
        ArrayList<CombatantGroup> arrayList = new ArrayList<CombatantGroup>();
        for (CombatantGroup combatantGroup : list) {
            if (!combatantGroup.isActive()) continue;
            int n = combatantGroup.range + combatant.range + 1;
            int n2 = combatAction.getRangeFrom().ordinal();
            int n3 = combatAction.getRangeTo().ordinal();
            if (n2 > n || n > n3) continue;
            arrayList.add(combatantGroup);
        }
        return arrayList;
    }

    private static SummonCreature getSummonAction(CombatAction combatAction) {
        for (Action action : combatAction.getActions()) {
            if (!(action instanceof SummonCreature)) continue;
            SummonCreature summonCreature = (SummonCreature)action;
            return summonCreature;
        }
        return null;
    }

    public static List<ItemLoot> lootCombatants(List<Combatant> list) {
        LinkedList<ItemLoot> linkedList = new LinkedList<ItemLoot>();
        for (Combatant combatant : list) {
            ItemDrops itemDrops;
            if (!combatant.isDead() || combatant.hasRunAway() || (itemDrops = ItemDrops.forCreature(combatant.getId())) == null) continue;
            itemDrops.pickDrop(RPG.rand, linkedList);
        }
        return linkedList;
    }

    public static void removeCondition(String string, Combatant combatant, CombatLog combatLog) {
        combatant.removeCondition(string);
    }

    public static void tickConditions(int n, List<Combatant> list) {
        for (Combatant combatant : list) {
            combatant.tickConditions(n);
        }
    }
}

