/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.combat;

import de.slashbinbash.hexen.combat.Combatant;
import de.slashbinbash.hexen.combat.CombatantGroup;
import de.slashbinbash.hexen.factory.ItemFactory;
import de.slashbinbash.hexen.log.LogBase;
import de.slashbinbash.hexen.model.CombatAction;
import de.slashbinbash.hexen.model.Condition;
import de.slashbinbash.hexen.model.DamageInteger;
import de.slashbinbash.hexen.model.Item;
import de.slashbinbash.hexen.model.ItemLoot;
import de.slashbinbash.hexen.model.RestoreValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CombatLog
extends LogBase {
    private StringBuilder sb = new StringBuilder();

    public void AddCondition(Combatant combatant, Condition condition) {
        this.add(" %s received condition %s.", combatant.getName(), condition.getName());
    }

    public void Ambushing(List<CombatantGroup> list) {
        this.sb.append("You ambush:");
        for (CombatantGroup combatantGroup : list) {
            this.sb.append("\n").append(combatantGroup.size()).append(" ").append(combatantGroup.getName());
        }
        this.push(this.sb);
    }

    public void AmbushedBy(List<CombatantGroup> list) {
        this.sb.append("You are ambushed by:");
        for (CombatantGroup combatantGroup : list) {
            this.sb.append("\n").append(combatantGroup.size()).append(" ").append(combatantGroup.getName());
        }
        this.push(this.sb);
    }

    public void AttackedBy(List<CombatantGroup> list) {
        this.sb.append("You are attacked by:");
        for (CombatantGroup combatantGroup : list) {
            this.sb.append("\n").append(combatantGroup.size()).append(" ").append(combatantGroup.getName());
        }
        this.push(this.sb);
    }

    public void AttacksWith(Combatant combatant, Combatant combatant2, CombatAction combatAction) {
        if (combatant != combatant2) {
            this.add("%s used %s on %s (%d).", combatant.getName(), combatAction.getName(), combatant2.getName(), combatant2.range + 1);
        } else {
            this.add("%s used %s on self.", combatant.getName(), combatAction.getName());
        }
    }

    public void AttacksWith(Combatant combatant, List<Combatant> list, CombatAction combatAction) {
        switch (combatAction.getTarget()) {
            case SELF: {
                this.add("%s used %s on self.", combatant.getName(), combatAction.getName());
                break;
            }
            case ENEMY_ALL: {
                this.add("%s used %s on enemies.", combatant.getName(), combatAction.getName());
                break;
            }
            case ENEMY_GROUP_ALL: 
            case PARTY_GROUP_ALL: {
                this.add("%s used %s on %s group (%d).", combatant.getName(), combatAction.getName(), list.get(0).getName(), list.get((int)0).range + 1);
                break;
            }
            case ENEMY_ONE: 
            case ENEMY_GROUP_ONE: 
            case PARTY_ONE: {
                this.add("%s used %s on %s (%d).", combatant.getName(), combatAction.getName(), list.get(0).getName(), list.get((int)0).range + 1);
                break;
            }
            case PARTY_ALL: {
                this.add("%s used %s on party.", combatant.getName(), combatAction.getName());
                break;
            }
        }
    }

    public void ResistCondition(Combatant combatant, Condition condition) {
        this.add("%s resisted %s.", combatant.getName(), condition.getName());
    }

    public void IsImmuneTo(Combatant combatant, Condition condition) {
        this.add(" %s is immune to %s.", combatant.getName(), condition.getName());
    }

    public void Left(Combatant combatant) {
        this.add("%s left.", combatant.getName());
    }

    public void Defeated(Combatant combatant) {
        this.add(" %s was defeated.", combatant.getName());
    }

    public static void Loot(StringBuilder stringBuilder, List<ItemLoot> list) {
        if (list.isEmpty()) {
            stringBuilder.append("No loot");
        } else {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            stringBuilder.append("You find:\n");
            for (ItemLoot object : list) {
                if (hashMap.containsKey(object.itemID)) {
                    hashMap.put(object.itemID, (Integer)hashMap.get(object.itemID) + object.amount);
                    continue;
                }
                hashMap.put(object.itemID, object.amount);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                Item item = ItemFactory.createItem((String)entry.getKey());
                stringBuilder.append(entry.getValue()).append(" ").append(item.getName()).append("\n");
            }
        }
    }

    public void Loot(List<ItemLoot> list) {
        if (list.isEmpty()) {
            this.sb.append("No loot");
        } else {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            this.sb.append("You find:\n");
            for (ItemLoot object : list) {
                if (hashMap.containsKey(object.itemID)) {
                    hashMap.put(object.itemID, (Integer)hashMap.get(object.itemID) + object.amount);
                    continue;
                }
                hashMap.put(object.itemID, object.amount);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                Item item = ItemFactory.createItem((String)entry.getKey());
                this.sb.append(entry.getValue()).append(" ").append(item.getName()).append("\n");
            }
        }
        this.push(this.sb);
    }

    public void Miss(Combatant combatant, Combatant combatant2) {
        this.add(" Missed %s.", combatant2.getName());
    }

    public void NotEnoughActionPoints(Combatant combatant) {
        this.add("%s does not have enought AP.", combatant.getName());
    }

    public void CallForHelp(Combatant combatant, int n) {
        this.add("%s calls for help.", combatant.getName());
        if (n == 0) {
            this.add(" None arrived.", new Object[0]);
        } else if (n == 1) {
            this.add(" %d %s arrived.", n, combatant.getName());
        } else if (n > 1) {
            this.add(" %d %s arrived.", n, combatant.getName());
        }
    }

    public void Pass(Combatant combatant) {
        this.add("%s passes.", combatant.getName());
    }

    private void push(StringBuilder stringBuilder) {
        this.add(stringBuilder.toString(), new Object[0]);
        stringBuilder.setLength(0);
    }

    public void RemoveCondition(Combatant combatant, Condition condition) {
        this.add("%s lost condition %s.", combatant.getName(), condition.getName());
    }

    public void RemovedConditions(Combatant combatant, List<Condition> list) {
        for (Condition condition : list) {
            this.add(" %s loses condition %s.", combatant.getName(), condition.getName());
        }
    }

    public void StealItem(Combatant combatant, Item item, int n) {
        this.add(" %s steals %d %s.", combatant.getName(), n, item.getName());
    }

    public void RestoresDamage(Combatant combatant, Combatant combatant2, List<RestoreValue> list) {
        this.sb.append(combatant.getName());
        this.sb.append(" restores ");
        this.sb.append(combatant2.getName());
        for (RestoreValue restoreValue : list) {
            this.sb.append("\n - ");
            this.sb.append(restoreValue.value);
            this.sb.append(" ");
            this.sb.append(restoreValue.restore.component.toString());
        }
        this.push(this.sb);
    }

    public void RestoresHp(Combatant combatant, int n) {
        this.add(" %s restored %d HP.", combatant.getName(), n);
    }

    public void RestoresDamage(Combatant combatant, RestoreValue restoreValue) {
        this.add(" %s restored %d %s.", combatant.getName(), restoreValue.value, restoreValue.restore.component.toString());
    }

    public void RunAway(Combatant combatant, boolean bl) {
        if (bl) {
            this.add("%s ran away.", combatant.getName());
        } else {
            this.add("%s failed to run away.", combatant.getName());
        }
    }

    public void Summon(Combatant combatant, Combatant combatant2) {
        this.add("%s summons %s.", combatant.getName(), combatant2.getName());
    }

    public void TookDamage(Combatant combatant, DamageInteger damageInteger, boolean bl) {
        if (bl) {
            this.add(" %s was crit. hit for %d %s damage.", combatant.getName(), damageInteger.value, damageInteger.damage.type.name);
        } else {
            this.add(" %s was hit for %d %s damage.", combatant.getName(), damageInteger.value, damageInteger.damage.type.name);
        }
    }

    public void TookDamageFromCondition(Combatant combatant, DamageInteger damageInteger, Condition condition) {
        this.add("%s took %d %s damage from %s.", combatant.getName(), damageInteger.value, damageInteger.damage.type.name, condition.getName());
    }

    public void UseItem(Combatant combatant, Item item, boolean bl) {
        this.add("%s used %s.", combatant.getName(), item.getName());
    }
}

