/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.chest;

import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.StaticRPG;
import de.slashbinbash.hexen.action.Action;
import de.slashbinbash.hexen.chest.Chest;
import de.slashbinbash.hexen.model.ClassCreature;
import de.slashbinbash.hexen.model.Inventory;
import de.slashbinbash.hexen.model.Item;
import de.slashbinbash.hexen.model.Party;

public class StaticChest {
    public static StaticRPG.Result disarmTrap(Chest chest) {
        Party party = RPG.getInstance().party;
        assert (chest.state.trap_detected);
        Chest.Data.Trap trap = chest._data.trap;
        if (chest.state.trap_disarmed) {
            return StaticRPG.Result.SUCCESS;
        }
        if (trap.disarmCheck == null) {
            return StaticRPG.Result.SUCCESS;
        }
        if (trap.disarmItem != null) {
            if (!party.inventory.contains(trap.disarmItem)) {
                return StaticRPG.Result.ITEM_NOT_EXIST;
            }
            party.inventory.remove(trap.disarmItem, 1);
        }
        if (trap.disarmCheck.check(null)) {
            chest.state.trap_disarmed = true;
            return StaticRPG.Result.SUCCESS;
        }
        return StaticRPG.Result.FAILURE;
    }

    public static StaticRPG.Result lockpickLock(Chest chest) {
        Inventory inventory = RPG.getInstance().party.inventory;
        if (!chest.isLocked()) {
            return StaticRPG.Result.SUCCESS;
        }
        Chest.Data.Lock lock = chest._data.lock;
        if (lock.lockpickItem != null && !inventory.contains(lock.lockpickItem)) {
            return StaticRPG.Result.ITEM_NOT_EXIST;
        }
        if (lock.lockpickingCheck != null && !lock.lockpickingCheck.check(null)) {
            if (lock.lockpickItem != null) {
                inventory.remove(lock.lockpickItem, 1);
                return StaticRPG.Result.SKILL_CHECK_FAIL_ITEM_BREAK;
            }
            return StaticRPG.Result.SKILL_CHECK_FAIL;
        }
        chest.state.lock_unlocked = true;
        return StaticRPG.Result.SUCCESS;
    }

    public static StaticRPG.Result openChest(Chest chest) {
        RPG rPG = RPG.getInstance();
        if (chest.state.opened) {
            return StaticRPG.Result.SUCCESS;
        }
        if (chest.isLocked()) {
            return StaticRPG.Result.LOCKED;
        }
        StaticRPG.Result result = StaticRPG.Result.SUCCESS;
        if (chest.hasTrap()) {
            ClassCreature classCreature = rPG.party.pickRandom();
            for (Action action : chest._data.trap.actions) {
                action.perform(classCreature);
            }
            chest.state.trap_detected = true;
            chest.state.trap_disarmed = true;
            result = StaticRPG.Result.TRAPPED;
        }
        chest.state.opened = true;
        return result;
    }

    public static StaticRPG.Result unlockLock(Chest chest) {
        RPG rPG = RPG.getInstance();
        if (!chest.isLocked()) {
            return StaticRPG.Result.SUCCESS;
        }
        Item item = rPG.party.inventory.get(chest._data.lock.keyItem);
        if (item == null) {
            return StaticRPG.Result.ITEM_NOT_EXIST;
        }
        chest.state.lock_unlocked = true;
        return StaticRPG.Result.SUCCESS;
    }
}

