/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.check;

import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.check.ICheck;
import de.slashbinbash.hexen.model.ClassCreature;
import de.slashbinbash.hexen.model.Party;
import java.util.Iterator;

public class ConditionCheck
implements ICheck {
    public String conditionId;
    public Type type = Type.OneOrMore;

    public ConditionCheck(String string) {
        this.conditionId = string;
    }

    @Override
    public boolean check(Object object) {
        if (object instanceof ClassCreature) {
            ClassCreature classCreature = (ClassCreature)object;
            return classCreature.hasCondition(this.conditionId);
        }
        Party party = null;
        if (object instanceof Party) {
            Iterator<ClassCreature> iterator = (Party)object;
            party = iterator;
        } else {
            party = RPG.getInstance().party;
        }
        switch (this.type.ordinal()) {
            case 0: {
                for (ClassCreature classCreature : party.getMembers()) {
                    if (classCreature.hasCondition(this.conditionId)) continue;
                    return false;
                }
                return true;
            }
            case 1: {
                for (ClassCreature classCreature : party.getMembers()) {
                    if (!classCreature.hasCondition(this.conditionId)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public static enum Type {
        All,
        OneOrMore;

    }
}

