/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.audio;

import de.slashbinbash.hexen.audio.Sample;
import de.slashbinbash.hexen.model.Scene;
import java.util.HashMap;
import java.util.Map;

public class SoundEngine {
    private HashMap<String, Sample> samples = new HashMap();

    public void clear() {
        for (Map.Entry<String, Sample> entry : this.samples.entrySet()) {
            Sample sample = entry.getValue();
            sample.stop();
            sample.close();
        }
        this.samples.clear();
    }

    public boolean isPlaying(Scene.Sound sound) {
        Sample sample = this.samples.get(sound.id);
        return sample.isLoaded() && sample.isRunning();
    }

    public void startSample(String string) {
        if (this.samples.containsKey(string)) {
            this.samples.get(string).start();
        } else {
            System.out.println("SoundEngine - No sample with ID: " + string);
        }
    }

    public boolean openSample(Scene.Sound sound) {
        if (this.samples.containsKey(sound.id)) {
            return true;
        }
        Sample sample = new Sample(sound);
        if (!sample.file.exists()) {
            System.out.println("SoundEngine - File does not exist " + sample.file.getAbsolutePath());
            return false;
        }
        sample.open();
        this.samples.put(sound.id, sample);
        return true;
    }

    public void swapSamples(Scene.Sound[] soundArray) {
        for (Map.Entry<String, Sample> entry : this.samples.entrySet()) {
            boolean bl = false;
            for (Scene.Sound sound : soundArray) {
                if (!sound.id.equals(entry.getKey())) continue;
                bl = true;
                break;
            }
            Sample sample = entry.getValue();
            if (bl) {
                if (sample.isRunning()) continue;
                sample.start();
                continue;
            }
            sample.stop();
        }
    }

    public void startSample(Scene.Sound sound) {
        this.samples.get(sound.id).start();
    }

    public void stopSample(Scene.Sound sound) {
        this.samples.get(sound.id).stop();
    }

    public void stopSamples() {
        for (Sample sample : this.samples.values()) {
            sample.stop();
        }
    }

    public static enum Layer {
        Effect,
        Music;

    }
}

