/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.action;

import de.slashbinbash.hexen.action.Action;
import de.slashbinbash.hexen.action.Actions;
import de.slashbinbash.hexen.action.AddAbility;
import de.slashbinbash.hexen.action.AddCondition;
import de.slashbinbash.hexen.action.DealDamage;
import de.slashbinbash.hexen.action.LearnCombatAction;
import de.slashbinbash.hexen.action.RemoveCondition;
import de.slashbinbash.hexen.action.RestoreHP;
import de.slashbinbash.hexen.action.SetAbility;
import de.slashbinbash.hexen.factory.ConditionFactory;
import de.slashbinbash.hexen.model.ClassCreature;
import de.slashbinbash.hexen.model.Condition;
import de.slashbinbash.hexen.model.DamageRange;

public class StaticAction {
    public static String printAction(Action action, ClassCreature classCreature) {
        if (action instanceof AddAbility) {
            AddAbility addAbility = (AddAbility)action;
            if (addAbility.value > 0) {
                return String.format("%s has gained %d points in %s.", classCreature.name, addAbility.value, addAbility.ability.name);
            }
            if (addAbility.value < 0) {
                return String.format("%s has lost %d points in %s.", classCreature.name, addAbility.value, addAbility.ability.name);
            }
            return null;
        }
        if (action instanceof LearnCombatAction) {
            LearnCombatAction learnCombatAction = (LearnCombatAction)action;
            return String.format("%s learned %s.", classCreature.name, learnCombatAction.combatAction.getName());
        }
        if (action instanceof SetAbility) {
            SetAbility setAbility = (SetAbility)action;
            return String.format("%s has %d skill points in %s.", classCreature.name, setAbility.value, setAbility.ability.name);
        }
        return String.format("<%s>", action.getClass().getSimpleName());
    }

    public static void printActions(StringBuilder stringBuilder, Actions actions) {
        if (actions == null) {
            return;
        }
        for (Action action : actions) {
            stringBuilder.append("\n");
            if (action instanceof AddAbility) {
                AddAbility addAbility = (AddAbility)action;
                if (addAbility.value > 0) {
                    stringBuilder.append("+");
                }
                stringBuilder.append(addAbility.value);
                stringBuilder.append(" ");
                stringBuilder.append(addAbility.ability.name);
                continue;
            }
            if (action instanceof AddCondition) {
                AddCondition addCondition = (AddCondition)action;
                Condition.Data data = ConditionFactory.createCondition(addCondition.condition);
                stringBuilder.append("Adds ").append(data.name);
                if (!(addCondition.chance < 1.0f)) continue;
                stringBuilder.append(" (");
                stringBuilder.append((int)(addCondition.chance * 100.0f));
                stringBuilder.append("%)");
                continue;
            }
            if (action instanceof DealDamage) {
                DealDamage dealDamage = (DealDamage)action;
                DamageRange damageRange = dealDamage.damageRange;
                stringBuilder.append(damageRange.min);
                if (damageRange.min != damageRange.max) {
                    stringBuilder.append("-").append(damageRange.max);
                }
                stringBuilder.append(" ");
                stringBuilder.append(damageRange.damage.type.name);
                stringBuilder.append(" damage");
                continue;
            }
            if (action instanceof LearnCombatAction) {
                LearnCombatAction learnCombatAction = (LearnCombatAction)action;
                stringBuilder.append("+").append(learnCombatAction.combatAction.getName());
                continue;
            }
            if (action instanceof RemoveCondition) {
                RemoveCondition removeCondition = (RemoveCondition)action;
                Condition.Data data = ConditionFactory.createCondition(removeCondition.conditionId);
                stringBuilder.append("Removes ").append(data.name);
                continue;
            }
            if (action instanceof RestoreHP) {
                RestoreHP restoreHP = (RestoreHP)action;
                int n = restoreHP.min;
                int n2 = restoreHP.max;
                stringBuilder.append("Restores ");
                stringBuilder.append(n);
                if (n != n2) {
                    stringBuilder.append("-").append(n2);
                }
                stringBuilder.append(" HP");
                continue;
            }
            if (action instanceof SetAbility) {
                SetAbility setAbility = (SetAbility)action;
                stringBuilder.append(setAbility.ability.name).append(" ").append(setAbility.value);
                continue;
            }
            stringBuilder.append("<").append(action.getClass().getSimpleName()).append(">");
        }
    }
}

