/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.action;

import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.StaticLog;
import de.slashbinbash.hexen.StaticRPG;
import de.slashbinbash.hexen.action.Action;
import de.slashbinbash.hexen.door.Door;
import de.slashbinbash.hexen.door.DoorSystem;
import de.slashbinbash.hexen.door.StaticDoor;
import de.slashbinbash.hexen.map.MapObject;
import de.slashbinbash.hexen.map.TileEdge;
import de.slashbinbash.hexen.message.Message;
import de.slashbinbash.hexen.message.MessageBus;
import de.slashbinbash.hexen.model.Item;
import de.slashbinbash.hexen.model.Party;

public class OpenDoor
extends Action {
    public Door.Data data;

    public OpenDoor(Door.Data data) {
        this.data = data;
    }

    @Override
    public void perform(Object object) {
        DoorSystem doorSystem = RPG.getInstance().doorSystem;
        Party party = RPG.getInstance().party;
        String string = DoorSystem.getStateId(party.getLocation(), this.data);
        Door.State state = null;
        if (!doorSystem.hasState(string)) {
            state = new Door.State();
            state.id = string;
            doorSystem.setState(string, state);
        } else {
            state = doorSystem.getState(string);
        }
        if (object instanceof MapObject) {
            MapObject mapObject = (MapObject)object;
            Object object2 = mapObject.parent;
            if (object2 instanceof TileEdge) {
                TileEdge tileEdge = (TileEdge)object2;
                if (state.lock_unlocked) {
                    tileEdge.type = 2;
                    MessageBus.push(Message.UPDATE_MAP, null);
                    return;
                }
                object2 = new Door(this.data, state);
                StaticRPG.Result result = StaticDoor.unlockLock((Door)object2);
                if (result == StaticRPG.Result.SUCCESS) {
                    tileEdge.type = 2;
                    Item item = party.inventory.get(((Door)object2)._data.lock.keyItem);
                    StaticLog.log("Used %s to unlock door.", item.getName());
                    return;
                }
            }
        }
        MessageBus.push(Message.STATE_PUSH, new Door(this.data, state));
    }
}

