/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.action;

import de.slashbinbash.hexen.action.Action;
import de.slashbinbash.hexen.action.Actions;
import de.slashbinbash.hexen.action.AddAbility;
import de.slashbinbash.hexen.action.AddCombatAction;
import de.slashbinbash.hexen.action.AddCondition;
import de.slashbinbash.hexen.action.AddImmunity;
import de.slashbinbash.hexen.action.AddItem;
import de.slashbinbash.hexen.action.AddRecipe;
import de.slashbinbash.hexen.action.AddStat;
import de.slashbinbash.hexen.action.AddVim;
import de.slashbinbash.hexen.action.DealDamage;
import de.slashbinbash.hexen.action.IfElseAction;
import de.slashbinbash.hexen.action.InstaKill;
import de.slashbinbash.hexen.action.LearnCombatAction;
import de.slashbinbash.hexen.action.OpenBank;
import de.slashbinbash.hexen.action.OpenBestiary;
import de.slashbinbash.hexen.action.OpenChest;
import de.slashbinbash.hexen.action.OpenCombat;
import de.slashbinbash.hexen.action.OpenDoor;
import de.slashbinbash.hexen.action.OpenEvent;
import de.slashbinbash.hexen.action.OpenGuild;
import de.slashbinbash.hexen.action.OpenInn;
import de.slashbinbash.hexen.action.OpenModder;
import de.slashbinbash.hexen.action.OpenShop;
import de.slashbinbash.hexen.action.OpenTemple;
import de.slashbinbash.hexen.action.OpenTravel;
import de.slashbinbash.hexen.action.OpenWorkbench;
import de.slashbinbash.hexen.action.PassTime;
import de.slashbinbash.hexen.action.PickRandomMember;
import de.slashbinbash.hexen.action.PrintMessage;
import de.slashbinbash.hexen.action.RemoveAP;
import de.slashbinbash.hexen.action.RemoveCondition;
import de.slashbinbash.hexen.action.RemoveItem;
import de.slashbinbash.hexen.action.RemoveVim;
import de.slashbinbash.hexen.action.RestoreAP;
import de.slashbinbash.hexen.action.RestoreHP;
import de.slashbinbash.hexen.action.RevealLevel;
import de.slashbinbash.hexen.action.RevealLevelSegment;
import de.slashbinbash.hexen.action.Revive;
import de.slashbinbash.hexen.action.RunScript;
import de.slashbinbash.hexen.action.SetAbility;
import de.slashbinbash.hexen.action.SetDoorLocked;
import de.slashbinbash.hexen.action.SetEquipment;
import de.slashbinbash.hexen.action.SetQuest;
import de.slashbinbash.hexen.action.SetState;
import de.slashbinbash.hexen.action.SetVim;
import de.slashbinbash.hexen.action.ShowDescription;
import de.slashbinbash.hexen.action.StealHP;
import de.slashbinbash.hexen.action.StealItem;
import de.slashbinbash.hexen.action.SummonCreature;
import de.slashbinbash.hexen.action.Teleport;
import de.slashbinbash.hexen.check.CheckFactory;
import de.slashbinbash.hexen.chest.Chest;
import de.slashbinbash.hexen.chest.ChestFactory;
import de.slashbinbash.hexen.combat.CombatDescriptor;
import de.slashbinbash.hexen.combat.CombatFactory;
import de.slashbinbash.hexen.door.Door;
import de.slashbinbash.hexen.door.DoorFactory;
import de.slashbinbash.hexen.enums.Ability;
import de.slashbinbash.hexen.enums.Component;
import de.slashbinbash.hexen.factory.CombatActionFactory;
import de.slashbinbash.hexen.factory.Factory;
import de.slashbinbash.hexen.factory.ItemFactory;
import de.slashbinbash.hexen.map.Location;
import de.slashbinbash.hexen.model.DamageRange;
import de.slashbinbash.hexen.model.Item;
import de.slashbinbash.hexen.model.RestoreRange;
import de.slashbinbash.hexen.quest.QuestState;
import de.slashbinbash.util.StaticXML;
import org.w3c.dom.Element;

public class ActionFactory {
    public static Actions createActions(Element element) {
        Actions actions = new Actions();
        actions.once = StaticXML.getBool(element, "once", false);
        block103: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "IF": {
                    actions.add(ActionFactory.createIfElse(element2));
                    continue block103;
                }
                case "addAbility": {
                    actions.add(ActionFactory.createAddAbility(element2));
                    continue block103;
                }
                case "addCombatAction": {
                    actions.add(ActionFactory.createAddCombatAction(element2));
                    continue block103;
                }
                case "addCondition": {
                    actions.add(ActionFactory.createAddCondition(element2));
                    continue block103;
                }
                case "addImmunity": {
                    actions.add(ActionFactory.createAddImmunity(element2));
                    continue block103;
                }
                case "addItem": {
                    actions.add(ActionFactory.createAddItem(element2));
                    continue block103;
                }
                case "addRecipe": {
                    actions.add(ActionFactory.createAddRecipe(element2));
                    continue block103;
                }
                case "addStat": {
                    actions.add(ActionFactory.createAddStat(element2));
                    continue block103;
                }
                case "addVim": {
                    actions.add(ActionFactory.createAddVim(element2));
                    continue block103;
                }
                case "dealDamage": {
                    actions.add(ActionFactory.createDealDamage(element2));
                    continue block103;
                }
                case "instaKill": {
                    actions.add(ActionFactory.createInstaKill(element2));
                    continue block103;
                }
                case "learnCombatAction": {
                    actions.add(ActionFactory.createLearnCombatAction(element2));
                    continue block103;
                }
                case "openBank": {
                    actions.add(ActionFactory.createOpenBank(element2));
                    continue block103;
                }
                case "openBestiary": {
                    actions.add(ActionFactory.createOpenBestiary(element2));
                    continue block103;
                }
                case "openChest": {
                    actions.add(ActionFactory.createOpenChest(element2));
                    continue block103;
                }
                case "openCombat": {
                    actions.add(ActionFactory.createOpenCombat(element2));
                    continue block103;
                }
                case "openDoor": {
                    actions.add(ActionFactory.createOpenDoor(element2));
                    continue block103;
                }
                case "openEvent": {
                    actions.add(ActionFactory.createOpenEvent(element2));
                    continue block103;
                }
                case "openGuild": {
                    actions.add(ActionFactory.createOpenGuild(element2));
                    continue block103;
                }
                case "openInn": {
                    actions.add(ActionFactory.createOpenInn(element2));
                    continue block103;
                }
                case "openModder": {
                    actions.add(ActionFactory.createOpenModder(element2));
                    continue block103;
                }
                case "openShop": {
                    actions.add(ActionFactory.createOpenShop(element2));
                    continue block103;
                }
                case "openTemple": {
                    actions.add(ActionFactory.createOpenTemple(element2));
                    continue block103;
                }
                case "openTravel": {
                    actions.add(ActionFactory.createOpenTravel(element2));
                    continue block103;
                }
                case "openWorkbench": {
                    actions.add(ActionFactory.createOpenWorkbench(element2));
                    continue block103;
                }
                case "passTime": {
                    actions.add(ActionFactory.createPassTime(element2));
                    continue block103;
                }
                case "pickRandomMember": {
                    actions.add(ActionFactory.createPickRandomMember(element2));
                    continue block103;
                }
                case "print": 
                case "printMessage": {
                    actions.add(ActionFactory.createPrintMessage(element2));
                    continue block103;
                }
                case "removeAP": {
                    actions.add(ActionFactory.createRemoveAp(element2));
                    continue block103;
                }
                case "removeCondition": {
                    actions.add(ActionFactory.createRemoveCondition(element2));
                    continue block103;
                }
                case "removeItem": {
                    actions.add(ActionFactory.createRemoveItem(element2));
                    continue block103;
                }
                case "removeVim": {
                    actions.add(ActionFactory.createRemoveVim(element2));
                    continue block103;
                }
                case "restoreAP": {
                    actions.add(ActionFactory.createRestoreAp(element2));
                    continue block103;
                }
                case "restoreHP": {
                    actions.add(ActionFactory.createRestoreHp(element2));
                    continue block103;
                }
                case "revealLevel": {
                    actions.add(ActionFactory.createRevealLevel(element2));
                    continue block103;
                }
                case "revealLevelSegment": {
                    actions.add(ActionFactory.createRevealLevelSegment(element2));
                    continue block103;
                }
                case "revive": {
                    actions.add(ActionFactory.createRevive(element2));
                    continue block103;
                }
                case "script": {
                    actions.add(ActionFactory.createRunScript(element2));
                    continue block103;
                }
                case "setAbility": {
                    actions.add(ActionFactory.createSetAbility(element2));
                    continue block103;
                }
                case "setDoorLocked": {
                    actions.add(ActionFactory.createSetDoorLocked(element2));
                    continue block103;
                }
                case "setEquipment": {
                    actions.add(ActionFactory.createSetEquipment(element2));
                    continue block103;
                }
                case "setQuest": {
                    actions.add(ActionFactory.createSetQuest(element2));
                    continue block103;
                }
                case "setState": {
                    actions.add(ActionFactory.createSetState(element2));
                    continue block103;
                }
                case "setVim": {
                    actions.add(ActionFactory.createSetVim(element2));
                    continue block103;
                }
                case "showDescription": {
                    actions.add(ActionFactory.createShowDescription(element2));
                    continue block103;
                }
                case "stealHP": {
                    actions.add(ActionFactory.createStealHp(element2));
                    continue block103;
                }
                case "stealItem": {
                    actions.add(ActionFactory.createStealItem(element2));
                    continue block103;
                }
                case "summonCreature": {
                    actions.add(ActionFactory.createSummonCreature(element2));
                    continue block103;
                }
                case "teleport": {
                    actions.add(ActionFactory.createTeleport(element2));
                    continue block103;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return actions;
    }

    private static Action createAddAbility(Element element) {
        Ability ability = Ability.valueOf(StaticXML.getAttribute(element, "ref"));
        int n = StaticXML.getInt(element, "value");
        return new AddAbility(ability, n);
    }

    private static Action createAddCombatAction(Element element) {
        return new AddCombatAction(CombatActionFactory.createCombatAction(element));
    }

    private static Action createAddCondition(Element element) {
        String string = StaticXML.getAttribute(element, "ref");
        AddCondition addCondition = new AddCondition(string);
        block10: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "duration": {
                    addCondition.duration = Factory.parseDuration(element2);
                    continue block10;
                }
                case "chance": {
                    addCondition.chance = Float.valueOf(StaticXML.getText(element2)).floatValue();
                    continue block10;
                }
                case "type": {
                    addCondition.type = AddCondition.Type.valueOf(StaticXML.getText(element2));
                    continue block10;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return addCondition;
    }

    private static Action createAddImmunity(Element element) {
        return new AddImmunity(Factory.createImmunity(element));
    }

    private static Action createAddItem(Element element) {
        String string = StaticXML.getAttribute(element, "ref");
        int n = StaticXML.getInt(element, "count");
        return new AddItem(string, n);
    }

    private static Action createAddRecipe(Element element) {
        return new AddRecipe(element.getAttribute("ref"));
    }

    private static Action createAddStat(Element element) {
        String string = StaticXML.getAttribute(element, "name");
        int n = StaticXML.getInt(element, "value");
        return new AddStat(string, n);
    }

    private static Action createAddVim(Element element) {
        int n = StaticXML.getInt(element, "value");
        return new AddVim(n);
    }

    private static Action createDealDamage(Element element) {
        DealDamage dealDamage = new DealDamage(Factory.createDamageRange(element));
        for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "object": {
                    dealDamage.varObject = StaticXML.getText(element2);
                }
            }
        }
        return dealDamage;
    }

    private static Action createIfElse(Element element) {
        IfElseAction ifElseAction = new IfElseAction();
        for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "TEST": {
                    ifElseAction.condition = CheckFactory.createChecks(element2);
                    break;
                }
                case "THEN": {
                    ifElseAction.trueActions = ActionFactory.createActions(element2);
                    break;
                }
                case "ELSE": {
                    ifElseAction.falseActions = ActionFactory.createActions(element2);
                }
            }
        }
        return ifElseAction;
    }

    private static Action createInstaKill(Element element) {
        return new InstaKill();
    }

    private static Action createLearnCombatAction(Element element) {
        return new LearnCombatAction(StaticXML.getAttribute(element, "ref"));
    }

    private static Action createOpenBank(Element element) {
        return new OpenBank();
    }

    private static Action createOpenBestiary(Element element) {
        return new OpenBestiary();
    }

    private static Action createOpenChest(Element element) {
        Chest.Data data = ChestFactory.createChestDesc(element);
        return new OpenChest(data);
    }

    private static Action createOpenCombat(Element element) {
        CombatDescriptor combatDescriptor = CombatFactory.createCombatDescriptor(element);
        return new OpenCombat(combatDescriptor);
    }

    private static Action createOpenDoor(Element element) {
        Door.Data data = DoorFactory.createDoorDesc(element);
        return new OpenDoor(data);
    }

    private static Action createOpenEvent(Element element) {
        String string = StaticXML.getAttribute(element, "ref");
        return new OpenEvent(string);
    }

    private static Action createOpenGuild(Element element) {
        String string = StaticXML.getAttribute(element, "ref");
        return new OpenGuild(string);
    }

    private static Action createOpenInn(Element element) {
        String string = StaticXML.getAttribute(element, "ref");
        return new OpenInn(string);
    }

    private static Action createOpenModder(Element element) {
        String string = StaticXML.getAttribute(element, "ref");
        return new OpenModder(string);
    }

    private static Action createOpenShop(Element element) {
        String string = StaticXML.getAttribute(element, "ref");
        return new OpenShop(string);
    }

    private static Action createOpenTemple(Element element) {
        String string = StaticXML.getAttribute(element, "ref");
        return new OpenTemple(string);
    }

    private static Action createOpenTravel(Element element) {
        String string = StaticXML.getAttribute(element, "ref");
        return new OpenTravel(string);
    }

    private static Action createOpenWorkbench(Element element) {
        return new OpenWorkbench(StaticXML.getAttribute(element, "ref"));
    }

    private static Action createPassTime(Element element) {
        long l = Factory.parseDuration(element);
        return new PassTime(l);
    }

    private static Action createPickRandomMember(Element element) {
        PickRandomMember pickRandomMember = new PickRandomMember();
        pickRandomMember.varCreature = StaticXML.getAttribute(element, "object");
        pickRandomMember.varCreatureName = StaticXML.getAttribute(element, "name");
        return pickRandomMember;
    }

    private static Action createPrintMessage(Element element) {
        String string = Factory.unformatMD(StaticXML.getText(element));
        return new PrintMessage(string);
    }

    private static Action createRemoveAp(Element element) {
        int n = StaticXML.getInt(element, "min");
        int n2 = StaticXML.getInt(element, "max");
        return new RemoveAP(n, n2);
    }

    private static Action createRemoveCondition(Element element) {
        String string = StaticXML.getAttribute(element, "ref");
        float f = StaticXML.getFloat(element, "chance", 1.0f);
        return new RemoveCondition(string, f);
    }

    private static Action createRemoveItem(Element element) {
        String string = StaticXML.getAttribute(element, "ref");
        int n = StaticXML.getInt(element, "count");
        return new RemoveItem(string, n);
    }

    private static Action createRemoveVim(Element element) {
        int n = StaticXML.getInt(element, "min");
        int n2 = StaticXML.getInt(element, "max");
        return new RemoveVim(n, n2);
    }

    private static Action createRestoreAp(Element element) {
        int n = StaticXML.getInt(element, "min");
        int n2 = StaticXML.getInt(element, "max");
        RestoreRange restoreRange = new RestoreRange(Component.AP, n, n2);
        return new RestoreAP(restoreRange);
    }

    private static Action createRestoreHp(Element element) {
        int n = StaticXML.getInt(element, "min");
        int n2 = StaticXML.getInt(element, "max");
        return new RestoreHP(n, n2);
    }

    private static Action createRevealLevel(Element element) {
        return new RevealLevel();
    }

    private static Action createRevealLevelSegment(Element element) {
        return new RevealLevelSegment();
    }

    private static Action createRevive(Element element) {
        return new Revive();
    }

    private static Action createRunScript(Element element) {
        return new RunScript(StaticXML.getText(element));
    }

    private static Action createSetAbility(Element element) {
        Ability ability = Ability.valueOf(StaticXML.getAttribute(element, "ref"));
        int n = StaticXML.getInt(element, "value");
        return new SetAbility(ability, n);
    }

    private static Action createSetDoorLocked(Element element) {
        Location location = new Location();
        String string = null;
        boolean bl = false;
        block10: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "location": {
                    location.mapId = StaticXML.getAttribute(element2, "mapId");
                    location.level = StaticXML.getInt(element2, "level");
                    continue block10;
                }
                case "door": {
                    string = StaticXML.getAttribute(element2, "id");
                    continue block10;
                }
                case "locked": {
                    bl = Boolean.valueOf(StaticXML.getText(element2));
                    continue block10;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return new SetDoorLocked(location, string, bl);
    }

    private static Action createSetEquipment(Element element) {
        Item item = ItemFactory.createItem(StaticXML.getAttribute(element, "ref"));
        return new SetEquipment(item);
    }

    private static Action createSetQuest(Element element) {
        String string = StaticXML.getAttribute(element, "ref");
        QuestState questState = QuestState.valueOf(StaticXML.getAttribute(element, "state").toUpperCase());
        return new SetQuest(string, questState);
    }

    private static Action createSetState(Element element) {
        String string = StaticXML.getAttribute(element, "name");
        String string2 = StaticXML.getAttribute(element, "value", null);
        return new SetState(string, string2);
    }

    private static Action createSetVim(Element element) {
        int n = StaticXML.getInt(element, "value");
        return new SetVim(n);
    }

    private static Action createShowDescription(Element element) {
        return new ShowDescription(StaticXML.getText(element));
    }

    private static Action createStealHp(Element element) {
        DamageRange damageRange = Factory.createDamageRange(element);
        return new StealHP(damageRange);
    }

    private static Action createStealItem(Element element) {
        String string = StaticXML.getAttribute(element, "name");
        int n = StaticXML.getInt(element, "min");
        int n2 = StaticXML.getInt(element, "max");
        return new StealItem(string, n, n2);
    }

    private static Action createSummonCreature(Element element) {
        return new SummonCreature(Factory.createSummonDescription(element));
    }

    private static Action createTeleport(Element element) {
        boolean bl = StaticXML.hasAttribute(element, "map");
        boolean bl2 = StaticXML.hasAttribute(element, "level");
        if (bl && bl2) {
            String string = StaticXML.getAttribute(element, "map");
            int n = StaticXML.getInt(element, "level");
            int n2 = StaticXML.getInt(element, "x");
            int n3 = StaticXML.getInt(element, "y");
            return new Teleport(string, n, n2, n3);
        }
        if (!bl && bl2) {
            int n = StaticXML.getInt(element, "level");
            int n4 = StaticXML.getInt(element, "x");
            int n5 = StaticXML.getInt(element, "y");
            return new Teleport(n, n4, n5);
        }
        if (bl && !bl2) {
            StaticXML.errAttributeMissing(element, "level");
        } else if (!bl && !bl2) {
            int n = StaticXML.getInt(element, "x");
            int n6 = StaticXML.getInt(element, "y");
            return new Teleport(n, n6);
        }
        throw new RuntimeException("Undefined");
    }
}

