/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen;

import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.Util;
import de.slashbinbash.hexen.action.Action;
import de.slashbinbash.hexen.action.StealHP;
import de.slashbinbash.hexen.enums.Direction;
import de.slashbinbash.hexen.map.Level;
import de.slashbinbash.hexen.map.Location;
import de.slashbinbash.hexen.map.Map;
import de.slashbinbash.hexen.map.Tile;
import de.slashbinbash.hexen.map.TileEdge;
import de.slashbinbash.hexen.map.TileObject;
import de.slashbinbash.hexen.map.TileProperty;
import de.slashbinbash.hexen.message.Message;
import de.slashbinbash.hexen.message.MessageBus;
import de.slashbinbash.hexen.model.ClassCreature;
import de.slashbinbash.hexen.model.CombatAction;
import de.slashbinbash.hexen.model.DamageInteger;
import de.slashbinbash.hexen.model.DamageRange;
import de.slashbinbash.hexen.model.Inventory;
import de.slashbinbash.hexen.model.Item;
import de.slashbinbash.hexen.model.Party;
import de.slashbinbash.hexen.model.RestoreRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class StaticRPG {
    public static boolean canDropItem(Item item) {
        Inventory inventory = RPG.getInstance().party.inventory;
        if (!item.isDropable()) {
            return false;
        }
        if (!inventory.contains(item)) {
            return false;
        }
        return !StaticRPG.isEquipped(item);
    }

    public static int countEquipped(Item item) {
        Party party = RPG.getInstance().party;
        int n = 0;
        for (ClassCreature classCreature : party.getMembers()) {
            if (classCreature.equipment != item) continue;
            ++n;
        }
        return n;
    }

    public static Result doCombatAction(CombatAction combatAction, ClassCreature classCreature, ClassCreature classCreature2) {
        Result result = Result.OK;
        if (classCreature.actionPoints < combatAction.getActionPointCost()) {
            return Result.NOT_ENOUGH_ACTION_POINTS;
        }
        classCreature.actionPoints -= combatAction.getActionPointCost();
        for (Action action : combatAction.getActions()) {
            if (action instanceof StealHP) {
                StealHP stealHP = (StealHP)action;
                int n = StaticRPG.roll((DamageRange)stealHP.damageRange).value;
                assert (n >= 0);
                classCreature2.hitPoints = Math.max(classCreature2.hitPoints - n, 0);
                classCreature.hitPoints = Math.min(classCreature.hitPoints + n, classCreature.calcMaxHitPoints());
                continue;
            }
            action.perform(classCreature2);
        }
        return result;
    }

    public static Result doCombatAction(CombatAction combatAction, ClassCreature classCreature, List<ClassCreature> list) {
        Result result = Result.OK;
        if (classCreature.actionPoints < combatAction.getActionPointCost()) {
            return Result.NOT_ENOUGH_ACTION_POINTS;
        }
        classCreature.actionPoints -= combatAction.getActionPointCost();
        for (ClassCreature classCreature2 : list) {
            for (Action action : combatAction.getActions()) {
                if (action instanceof StealHP) {
                    StealHP stealHP = (StealHP)action;
                    int n = StaticRPG.roll((DamageRange)stealHP.damageRange).value;
                    assert (n >= 0);
                    classCreature2.hitPoints = Math.max(classCreature2.hitPoints - n, 0);
                    classCreature.hitPoints = Math.min(classCreature.hitPoints + n, classCreature.calcMaxHitPoints());
                    continue;
                }
                action.perform(classCreature2);
            }
        }
        return result;
    }

    public static boolean doDamage(DamageInteger damageInteger, ClassCreature classCreature) {
        int n = classCreature.calcDamageReduction(damageInteger.damage);
        damageInteger.value = Math.max(damageInteger.value - n, 0);
        float f = classCreature.calcDamageResistance(damageInteger.damage);
        float f2 = Util.clamp(1.0f - f, 0.0f, 1.0f);
        damageInteger.value = (int)((float)damageInteger.value * f2);
        switch (damageInteger.getComponent()) {
            case HP: {
                classCreature.hitPoints = Math.max(classCreature.hitPoints - damageInteger.value, 0);
                break;
            }
            case AP: {
                classCreature.actionPoints = Math.max(classCreature.actionPoints - damageInteger.value, 0);
                break;
            }
            default: {
                assert (false) : "Unknown component";
                break;
            }
        }
        return true;
    }

    public static Result dropItem(Item item) {
        return StaticRPG.dropItem(item, false);
    }

    private static Result dropItem(Item item, boolean bl) {
        RPG rPG = RPG.getInstance();
        if (!StaticRPG.canDropItem(item)) {
            return Result.ITEM_NOT_DROPABLE;
        }
        if (bl) {
            rPG.party.inventory.removeAll(item);
        } else {
            rPG.party.inventory.remove(item, 1);
        }
        return Result.OK;
    }

    public static Result dropItemAll(Item item) {
        return StaticRPG.dropItem(item, true);
    }

    public static Result equipItem(ClassCreature classCreature, Item item) {
        assert (item.isEquipable());
        if (classCreature.equipment != null) {
            return Result.ITEM_ALREADY_EQUIPPED;
        }
        if (classCreature.equipment == item) {
            return Result.ITEM_ALREADY_EQUIPPED;
        }
        if (item._data.requirements != null && !item._data.requirements.checkAll(classCreature)) {
            return Result.FAILURE;
        }
        assert (!StaticRPG.isEquipped(item));
        RPG.getInstance().party.inventory.remove(item);
        classCreature.equipment = item;
        return Result.OK;
    }

    public static boolean isEquipped(Item item) {
        Party party = RPG.getInstance().party;
        for (ClassCreature classCreature : party.getMembers()) {
            if (classCreature.equipment != item) continue;
            return true;
        }
        return false;
    }

    public static Result learnCombatAction(ClassCreature classCreature, CombatAction combatAction) {
        if (combatAction._data.requirements != null && !combatAction._data.requirements.checkAll(classCreature)) {
            return Result.SKILL_CHECK_FAIL;
        }
        classCreature.combatActions.add(combatAction);
        return Result.OK;
    }

    public static Result move(Party party, Direction direction) {
        if (!party.canMove()) {
            return Result.FAILURE;
        }
        Location location = party.getLocation();
        Level level = location.getLevel();
        Tile tile = level.getTile(location.x, location.y);
        TileEdge tileEdge = tile.getEdge(direction);
        if (tileEdge != null) {
            if (tileEdge.actions != null) {
                for (Action action : tileEdge.actions) {
                    action.perform(party);
                }
            }
            if (tileEdge.object != null) {
                for (Action action : tileEdge.object.actions) {
                    action.perform(tileEdge.object);
                }
            }
        }
        if (tileEdge.isBlocked(direction)) {
            boolean bl = true;
            if (tileEdge.passableChecks != null) {
                boolean bl2 = bl = !tileEdge.passableChecks.checkAll(null);
            }
            if (bl) {
                return Result.PATH_BLOCKED;
            }
        }
        if (level != null) {
            if (direction == Direction.UP || direction == Direction.DOWN) {
                return Result.FAILURE;
            }
            int n = location.x;
            int n2 = location.y;
            int n3 = level.width;
            int n4 = level.height;
            boolean bl = level.loop;
            if (direction == Direction.EAST) {
                n = n + 1 >= n3 ? (bl ? 0 : n) : ++n;
            } else if (direction == Direction.WEST) {
                n = n - 1 < 0 ? (bl ? n3 - 1 : n) : --n;
            } else if (direction == Direction.NORTH) {
                n2 = n2 - 1 < 0 ? (bl ? n4 - 1 : n2) : --n2;
            } else if (direction == Direction.SOUTH) {
                n2 = n2 + 1 >= n4 ? (bl ? 0 : n2) : ++n2;
            } else {
                return Result.FAILURE;
            }
            if (level.tiles[n][n2] == null) {
                return Result.FAILURE;
            }
            if (level.tiles[n][n2].isSolid()) {
                return Result.PATH_BLOCKED;
            }
            return StaticRPG.move(party, n, n2);
        }
        return Result.FAILURE;
    }

    public static Result move(Party party, int n, int n2) {
        TileProperty tileProperty;
        if (!party.canMove()) {
            return Result.FAILURE;
        }
        Location location = party.getLocation();
        MessageBus.push(Message.SPACE_ON_EXIT, location);
        location.x = n;
        location.y = n2;
        Level level = location.getLevel();
        level.visited[n][n2] = true;
        StaticRPG.updateVisibility(level, n, n2);
        StaticRPG.passTime(location.getTimeScale());
        StaticRPG.updateObjectVisiblity(location.getTile());
        Tile tile = level.getTile(n, n2);
        if (tile.actions != null) {
            tile.actions.performAll(party);
        }
        if (level.properties != null && (tileProperty = level.properties.get(n, n2)) != null) {
            tileProperty.actions.performAll(party);
        }
        MessageBus.push(Message.SPACE_ON_ENTER, location);
        return Result.OK;
    }

    public static Result move(Party party, String string, int n, int n2, int n3) {
        assert (string != null);
        RPG rPG = RPG.getInstance();
        Map map = rPG.map;
        if (!string.equals(map.__id__)) {
            return rPG.switchToMap(string, n, n2, n3);
        }
        return StaticRPG.move(party, n2, n3);
    }

    public static void passTime(long l) {
        RPG.getInstance().passTime(l);
        RPG.getInstance().party.tickConditions(l);
    }

    public static ClassCreature pickRandom(List<ClassCreature> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(RPG.rand.nextInt(list.size()));
    }

    public static Result relocate(Party party, String string, int n, int n2, int n3) {
        assert (string != null);
        return RPG.getInstance().switchToMap(string, n, n2, n3);
    }

    public static boolean removeConditions(ClassCreature classCreature) {
        if (classCreature.hasConditions()) {
            classCreature.removeConditions();
        }
        return true;
    }

    public static boolean restoreAP(ClassCreature classCreature, int n) {
        assert (n >= 0);
        if (!classCreature.canRestoreAP()) {
            return false;
        }
        classCreature.actionPoints = Util.clamp(classCreature.actionPoints + n, 0, classCreature.calcMaxActionPoints());
        return true;
    }

    public static boolean restoreHP(ClassCreature classCreature) {
        if (!classCreature.canRestoreHP()) {
            return false;
        }
        classCreature.hitPoints = classCreature.calcMaxHitPoints();
        return true;
    }

    public static boolean revive(ClassCreature classCreature) {
        if (!classCreature.canRevive()) {
            return false;
        }
        classCreature.hitPoints = 1;
        ++classCreature.numRevives;
        return true;
    }

    public static DamageInteger roll(DamageRange damageRange) {
        int n = RPG.rand.nextInt(damageRange.min, damageRange.max + 1);
        return new DamageInteger(damageRange.damage, n);
    }

    public static int roll(int n, int n2) {
        return RPG.rand.nextInt(n, n2 + 1);
    }

    public static int roll(RestoreRange restoreRange) {
        return RPG.rand.nextInt(restoreRange.min, restoreRange.max + 1);
    }

    public static Result unequip(ClassCreature classCreature) {
        if (classCreature.equipment == null) {
            return Result.OK;
        }
        if (classCreature.equipment.isUnequipable()) {
            return Result.ITEM_NOT_UNEQUIPABLE;
        }
        Item item = classCreature.equipment;
        classCreature.equipment = null;
        RPG.getInstance().party.inventory.add(item);
        return Result.OK;
    }

    public static Result unlearnCombatAction(ClassCreature classCreature, CombatAction combatAction) {
        classCreature.combatActions.remove(combatAction);
        return Result.OK;
    }

    public static void updateObjectVisiblity(Tile tile) {
        for (TileObject tileObject : tile.objects) {
            if (tileObject.visibleChecks == null) continue;
            tileObject.visible = tileObject.visibleChecks.checkAll(tile);
        }
    }

    public static void updateVisibility(Level level, int n, int n2) {
        StaticRPG.updateVisibility1(level, n, n2);
    }

    private static void updateVisibility1(Level level, int n, int n2) {
        Tile tile = level.getTile(n, n2);
        level.visibility[n][n2] = true;
        if (tile.edgeWest.type == 0) {
            StaticRPG.updateVisibilityV(level, n - 1, n2);
        }
        if (tile.edgeNorth.type == 0) {
            StaticRPG.updateVisibilityH(level, n, n2 - 1);
        }
        if (tile.edgeEast.type == 0) {
            StaticRPG.updateVisibilityV(level, n + 1, n2);
        }
        if (tile.edgeSouth.type == 0) {
            StaticRPG.updateVisibilityH(level, n, n2 + 1);
        }
    }

    private static void updateVisibility2(Level level, int n, int n2) {
        if (level.visibility[n][n2]) {
            return;
        }
        Stack<P> stack = new Stack<P>();
        ArrayList<P> arrayList = new ArrayList<P>();
        class P {
            public int x;
            public int y;

            public P(int n, int n2) {
                this.x = n;
                this.y = n2;
            }

            public boolean equals(Object object) {
                if (object instanceof P) {
                    P p = (P)object;
                    return this.x == p.x && this.y == p.y;
                }
                return false;
            }
        }
        stack.push(new P(n, n2));
        while (!stack.isEmpty()) {
            P p;
            P p2 = (P)stack.pop();
            Tile tile = level.tiles[p2.x][p2.y];
            level.visibility[p2.x][p2.y] = true;
            arrayList.add(p2);
            if (p2.x - 1 > 0 && tile.getEdge((Direction)Direction.WEST).type == 0 && !stack.contains(p = new P(p2.x - 1, p2.y)) && !arrayList.contains(p)) {
                stack.push(p);
            }
            if (p2.y - 1 > 0 && tile.getEdge((Direction)Direction.NORTH).type == 0 && !stack.contains(p = new P(p2.x, p2.y - 1)) && !arrayList.contains(p)) {
                stack.push(p);
            }
            if (p2.x + 1 < level.width && tile.getEdge((Direction)Direction.EAST).type == 0 && !stack.contains(p = new P(p2.x + 1, p2.y)) && !arrayList.contains(p)) {
                stack.push(p);
            }
            if (p2.y + 1 >= level.height || tile.getEdge((Direction)Direction.SOUTH).type != 0 || stack.contains(p = new P(p2.x, p2.y + 1)) || arrayList.contains(p)) continue;
            stack.push(p);
        }
    }

    public static void revealLevelSegment() {
        Location location = RPG.getInstance().party.getLocation();
        Level level = location.getLevel();
        int n = location.x;
        int n2 = location.y;
        StaticRPG.updateVisibility2(level, n, n2);
    }

    private static void updateVisibilityH(Level level, int n, int n2) {
        Tile tile;
        if (level.loop) {
            n = Util.wrap(n, 0, level.width);
            n2 = Util.wrap(n2, 0, level.height);
        }
        if ((tile = level.getTile(n, n2)) == null) {
            return;
        }
        level.visibility[n][n2] = true;
        if (n - 1 >= 0 && tile.edgeWest.type == 0) {
            level.visibility[n - 1][n2] = true;
        }
        if (n + 1 < level.width && tile.edgeEast.type == 0) {
            level.visibility[n + 1][n2] = true;
        }
    }

    private static void updateVisibilityV(Level level, int n, int n2) {
        Tile tile;
        if (level.loop) {
            n = Util.wrap(n, 0, level.width);
            n2 = Util.wrap(n2, 0, level.height);
        }
        if ((tile = level.getTile(n, n2)) == null) {
            return;
        }
        level.visibility[n][n2] = true;
        if (n2 - 1 >= 0 && tile.edgeNorth.type == 0) {
            level.visibility[n][n2 - 1] = true;
        }
        if (n2 + 1 < level.height && tile.edgeSouth.type == 0) {
            level.visibility[n][n2 + 1] = true;
        }
    }

    public static Result useItem(ClassCreature classCreature, Item item, ClassCreature classCreature2) {
        RPG rPG = RPG.getInstance();
        if (!rPG.party.inventory.contains(item)) {
            return Result.INVALID_ITEM;
        }
        if (!item.isUseable()) {
            return Result.ITEM_NOT_USABLE;
        }
        if (item._data.requirements != null && !item._data.requirements.checkAll(classCreature)) {
            return Result.REQUIREMENT_CHECK_FAILED;
        }
        rPG.party.inventory.remove(item, 1);
        if (item.hasActions()) {
            for (Action action : item.getActions()) {
                action.perform(classCreature2);
            }
        }
        return Result.OK;
    }

    public static enum Result {
        OK,
        SUCCESS,
        FAILURE,
        EVENT_NOT_EXIST,
        INVALID_ABILITY_SCORE,
        LOCKED,
        INVALID_ITEM,
        ITEM_NOT_DROPABLE,
        ITEM_NOT_EQUIPABLE,
        ITEM_NOT_UNEQUIPABLE,
        ITEM_NOT_USABLE,
        ITEM_NOT_EXIST,
        ITEM_ALREADY_EQUIPPED,
        INVENTORY_FULL,
        NOT_ENOUGH_ACTION_POINTS,
        PATH_BLOCKED,
        SKILL_CHECK_FAIL,
        TRAPPED,
        SKILL_CHECK_FAIL_ITEM_BREAK,
        NOT_ENOUGH_CURRENCY,
        REQUIREMENT_CHECK_FAILED,
        unknown;

    }
}

