/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen;

import de.slashbinbash.hexen.Hexen;
import de.slashbinbash.hexen.MapLoader;
import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.StaticRPG;
import de.slashbinbash.hexen.audio.SoundSystem;
import de.slashbinbash.hexen.factory.Factory;
import de.slashbinbash.hexen.handler.HexenHandler;
import de.slashbinbash.hexen.map.Level;
import de.slashbinbash.hexen.map.Location;
import de.slashbinbash.hexen.map.Map;
import de.slashbinbash.hexen.message.Message;
import de.slashbinbash.hexen.message.MessageBus;
import de.slashbinbash.hexen.persistence.Loader;
import de.slashbinbash.hexen.persistence.SaveState;
import de.slashbinbash.hexen.persistence.Saver;
import de.slashbinbash.hexen.view.StaticView;
import de.slashbinbash.opengl.JoystickEvent;
import de.slashbinbash.opengl.KeyboardEvent;
import de.slashbinbash.opengl.MouseEvent;
import de.slashbinbash.opengl.renderer.Draw2D;
import java.io.File;

public class GameState {
    public RPG rpg = null;
    public HexenHandler handler = null;
    private SoundSystem soundSystem = null;
    private long drawCounter = 60L;

    public void draw(Draw2D draw2D) {
        if (this.drawCounter > 0L) {
            --this.drawCounter;
            if (this.drawCounter == 0L) {
                StaticView.conditionCycle = (StaticView.conditionCycle + 1) % 100;
                this.drawCounter = 60L;
            }
        }
        this.handler.draw(draw2D);
    }

    public void handleJoystickEvent(JoystickEvent joystickEvent) {
        this.handler.handleJoystick(joystickEvent);
    }

    public void handleKeyboard(KeyboardEvent keyboardEvent) {
        this.handler.handleKeyboard(keyboardEvent);
    }

    public void handleMouse(MouseEvent mouseEvent) {
        this.handler.handleMouse(mouseEvent);
    }

    public void loadGame(File file) throws Exception {
        long l = System.currentTimeMillis();
        if (this.soundSystem != null) {
            this.soundSystem.clear();
        }
        this.rpg = null;
        this.handler = null;
        this.soundSystem = null;
        MessageBus.clear();
        Factory.clearAllCaches();
        System.gc();
        Factory.loadAllCaches();
        this.rpg = RPG.newInstance();
        this.handler = new HexenHandler();
        this.soundSystem = new SoundSystem();
        SaveState saveState = Loader.load(file);
        this.loadSaveGame(saveState);
        long l2 = System.currentTimeMillis();
        System.out.println("Loaded game: " + file.getName() + " in " + (l2 - l) + "ms");
    }

    public void loadGame(String string) throws Exception {
        this.loadGame(new File(string));
    }

    private void loadSaveGame(SaveState saveState) throws Exception {
        RPG rPG = RPG.getInstance();
        Map map = MapLoader.load(saveState.location.mapId);
        int n = saveState.location.level;
        int n2 = saveState.location.x;
        int n3 = saveState.location.y;
        rPG.timeSeconds = saveState.timeSeconds;
        rPG.map = map;
        rPG.party = saveState.party;
        rPG.party.setLocation(new Location(map, n, n2, n3));
        if (saveState.levelVisited != null) {
            Level level = map.levels.get(n);
            for (int i = 0; i < level.width; ++i) {
                for (int j = 0; j < level.height; ++j) {
                    level.visited[i][j] = saveState.levelVisited[i][j];
                    level.visibility[i][j] = saveState.levelVisited[i][j];
                }
            }
        }
        StaticRPG.updateVisibility(map.levels.get(n), n2, n3);
        if (saveState.stateMap != null) {
            rPG.stateMap = saveState.stateMap;
        }
        if (saveState.bankSystem != null) {
            rPG.bankSystem = saveState.bankSystem;
        }
        if (saveState.bestiarySystem != null) {
            rPG.bestiarySystem = saveState.bestiarySystem;
        }
        if (saveState.chestSystem != null) {
            rPG.chestSystem = saveState.chestSystem;
        }
        if (saveState.deadpoolSystem != null) {
            rPG.deadpoolSystem = saveState.deadpoolSystem;
        }
        if (saveState.doorSystem != null) {
            rPG.doorSystem = saveState.doorSystem;
        }
        if (saveState.guildSystem != null) {
            rPG.guildSystem = saveState.guildSystem;
        }
        if (saveState.questSystem != null) {
            rPG.questSystem = saveState.questSystem;
        }
        if (saveState.recipeSystem != null) {
            rPG.recipeSystem = saveState.recipeSystem;
        }
        if (saveState.shopSystem != null) {
            rPG.shopSystem = saveState.shopSystem;
        }
        if (saveState.templeSystem != null) {
            rPG.templeSystem = saveState.templeSystem;
        }
        MessageBus.push(Message.SPACE_ON_LOAD, rPG.party.getLocation());
    }

    public void saveGame(File file) {
        long l = System.currentTimeMillis();
        SaveState saveState = Saver.createSaveGame(RPG.getInstance());
        Saver.saveXML(file, saveState);
        long l2 = System.currentTimeMillis();
        System.out.println("Saved game: " + file.getName() + " in " + (l2 - l) + "ms");
    }

    public void saveGame(String string) {
        this.saveGame(new File(string));
    }

    public void quickSave() {
        File file = new File(Factory.SAVES_PATH + "auto.xml");
        Hexen.game.saveGame(file);
    }

    public void quickLoad() {
        File file = new File(Factory.SAVES_PATH + "auto.xml");
        if (file.exists()) {
            try {
                Hexen.game.loadGame(file);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

